/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneType;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.SolverFunction;

public final class BackboneFunction
implements SolverFunction<Backbone> {
    private final Collection<Variable> variables;
    private final BackboneType type;

    private BackboneFunction(Collection<Variable> variables, BackboneType type) {
        this.variables = variables;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Backbone apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        SolverState stateBeforeBackbone = null;
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            stateBeforeBackbone = solver.saveState();
        }
        Backbone backbone = solver.underlyingSolver().computeBackbone(this.variables, this.type);
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            solver.loadState(stateBeforeBackbone);
        }
        return backbone;
    }

    public static class Builder {
        private Collection<Variable> variables;
        private BackboneType type = BackboneType.POSITIVE_AND_NEGATIVE;

        private Builder() {
        }

        public Builder variables(Collection<Variable> variables) {
            this.variables = variables;
            return this;
        }

        public Builder variables(Variable ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public Builder type(BackboneType type) {
            this.type = type;
            return this;
        }

        public BackboneFunction build() {
            return new BackboneFunction(this.variables, this.type);
        }
    }
}

