/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import java.util.Locale;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSClause;

public final class MSVariable {
    private Tristate assignment = Tristate.UNDEF;
    private int level = -1;
    private MSClause reason = null;
    private double activity = 0.0;
    private boolean polarity;
    private boolean decision;

    public MSVariable(boolean polarity) {
        this.polarity = polarity;
        this.decision = false;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public void setReason(MSClause reason) {
        this.reason = reason;
    }

    public MSClause reason() {
        return this.reason;
    }

    public void assign(Tristate assignment) {
        this.assignment = assignment;
    }

    public Tristate assignment() {
        return this.assignment;
    }

    public void rescaleActivity() {
        this.activity *= 1.0E-100;
    }

    public void incrementActivity(double inc) {
        this.activity += inc;
    }

    public double activity() {
        return this.activity;
    }

    public void setPolarity(boolean polarity) {
        this.polarity = polarity;
    }

    public boolean polarity() {
        return this.polarity;
    }

    public boolean decision() {
        return this.decision;
    }

    public void setDecision(boolean decision) {
        this.decision = decision;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "MSVariable{assignment=%s, level=%d, reason=%s, activity=%f, polarity=%s, decision=%s}", new Object[]{this.assignment, this.level, this.reason, this.activity, this.polarity, this.decision});
    }
}

