/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import org.logicng.collections.LNGIntVector;

public final class MSSoftClause {
    private final LNGIntVector clause;
    private final LNGIntVector relaxationVars;
    private int weight;
    private int assumptionVar;

    public MSSoftClause(LNGIntVector clause, int weight, int assumptionVar, LNGIntVector relaxationVars) {
        this.clause = new LNGIntVector(clause);
        this.weight = weight;
        this.assumptionVar = assumptionVar;
        this.relaxationVars = new LNGIntVector(relaxationVars);
    }

    public LNGIntVector clause() {
        return this.clause;
    }

    public int weight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public LNGIntVector relaxationVars() {
        return this.relaxationVars;
    }

    public int assumptionVar() {
        return this.assumptionVar;
    }

    public void setAssumptionVar(int assumptionVar) {
        this.assumptionVar = assumptionVar;
    }

    public String toString() {
        int lit;
        int i;
        StringBuilder sb = new StringBuilder(String.format("MSSoftClause{weight=%d, assumption=%d lits=[", this.weight, this.assumptionVar));
        for (i = 0; i < this.clause.size(); ++i) {
            lit = this.clause.get(i);
            sb.append((lit & 1) == 1 ? "-" : "").append(lit >> 1);
            if (i == this.clause.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("] relax[");
        for (i = 0; i < this.relaxationVars.size(); ++i) {
            lit = this.relaxationVars.get(i);
            sb.append((lit & 1) == 1 ? "-" : "").append(lit >> 1);
            if (i == this.relaxationVars.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]}");
        return sb.toString();
    }
}

