/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import java.util.Comparator;
import org.logicng.collections.LNGIntVector;

public final class MSClause {
    public static final Comparator<MSClause> glucoseComparator = (x, y) -> {
        if (x.size() > 2 && y.size() == 2) {
            return -1;
        }
        if (y.size() > 2 && x.size() == 2) {
            return 1;
        }
        if (x.size() == 2 && y.size() == 2) {
            return 1;
        }
        if (x.lbd() > y.lbd()) {
            return -1;
        }
        if (x.lbd() < y.lbd()) {
            return 1;
        }
        return x.activity() < y.activity() ? -1 : 1;
    };
    public static final Comparator<MSClause> minisatComparator = (x, y) -> x.size() > 2 && (y.size() == 2 || x.activity() < y.activity()) ? -1 : 1;
    private final LNGIntVector data;
    private final boolean learnt;
    private final boolean isAtMost;
    private double activity;
    private int szWithoutSelectors;
    private boolean seen;
    private long lbd;
    private boolean canBeDel;
    private boolean oneWatched;
    private int atMostWatchers;

    public MSClause(LNGIntVector ps, boolean learnt) {
        this(ps, learnt, false);
    }

    public MSClause(LNGIntVector ps, boolean learnt, boolean isAtMost) {
        this.data = new LNGIntVector(ps.size());
        for (int i = 0; i < ps.size(); ++i) {
            this.data.unsafePush(ps.get(i));
        }
        this.learnt = learnt;
        this.szWithoutSelectors = 0;
        this.seen = false;
        this.lbd = 0L;
        this.canBeDel = true;
        this.oneWatched = false;
        this.isAtMost = isAtMost;
        this.atMostWatchers = -1;
    }

    public int size() {
        return this.data.size();
    }

    public int get(int i) {
        return this.data.get(i);
    }

    public void set(int i, int lit) {
        this.data.set(i, lit);
    }

    public double activity() {
        return this.activity;
    }

    public void incrementActivity(double inc) {
        this.activity += inc;
    }

    public void rescaleActivity() {
        this.activity *= 1.0E-20;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public int sizeWithoutSelectors() {
        return this.szWithoutSelectors;
    }

    public void setSizeWithoutSelectors(int szWithoutSelectors) {
        this.szWithoutSelectors = szWithoutSelectors;
    }

    public boolean seen() {
        return this.seen;
    }

    public void setSeen(boolean seen) {
        this.seen = seen;
    }

    public long lbd() {
        return this.lbd;
    }

    public void setLBD(long lbd) {
        this.lbd = lbd;
    }

    public boolean canBeDel() {
        return this.canBeDel;
    }

    public void setCanBeDel(boolean canBeDel) {
        this.canBeDel = canBeDel;
    }

    public boolean oneWatched() {
        return this.oneWatched;
    }

    public void setOneWatched(boolean oneWatched) {
        this.oneWatched = oneWatched;
    }

    public boolean isAtMost() {
        return this.isAtMost;
    }

    public int atMostWatchers() {
        assert (this.isAtMost);
        return this.atMostWatchers;
    }

    public void setAtMostWatchers(int atMostWatchers) {
        assert (this.isAtMost);
        this.atMostWatchers = atMostWatchers;
    }

    public void pop() {
        this.data.pop();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MSClause{");
        sb.append("activity=").append(this.activity).append(", ");
        sb.append("learnt=").append(this.learnt).append(", ");
        sb.append("szWithoutSelectors=").append(this.szWithoutSelectors).append(", ");
        sb.append("seen=").append(this.seen).append(", ");
        sb.append("lbd=").append(this.lbd).append(", ");
        sb.append("canBeDel=").append(this.canBeDel).append(", ");
        sb.append("oneWatched=").append(this.oneWatched).append(", ");
        sb.append("isAtMost=").append(this.isAtMost).append(", ");
        sb.append("atMostWatchers=").append(this.atMostWatchers).append(", ");
        sb.append("lits=[");
        for (int i = 0; i < this.data.size(); ++i) {
            int lit = this.data.get(i);
            sb.append((lit & 1) == 1 ? "-" : "").append(lit >> 1);
            if (i == this.data.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]}");
        return sb.toString();
    }
}

