/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import org.logicng.collections.LNGIntVector;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public final class LNGHeap {
    private final MiniSatStyleSolver s;
    private final LNGIntVector heap;
    private final LNGIntVector indices;

    public LNGHeap(MiniSatStyleSolver solver) {
        this.s = solver;
        this.heap = new LNGIntVector(1000);
        this.indices = new LNGIntVector(1000);
    }

    private static int left(int pos) {
        return pos * 2 + 1;
    }

    private static int right(int pos) {
        return (pos + 1) * 2;
    }

    private static int parent(int pos) {
        return pos - 1 >> 1;
    }

    public int size() {
        return this.heap.size();
    }

    public boolean empty() {
        return this.heap.size() == 0;
    }

    public boolean inHeap(int n) {
        return n < this.indices.size() && this.indices.get(n) >= 0;
    }

    public int get(int index) {
        assert (index < this.heap.size());
        return this.heap.get(index);
    }

    public void decrease(int n) {
        assert (this.inHeap(n));
        this.percolateUp(this.indices.get(n));
    }

    public void insert(int n) {
        this.indices.growTo(n + 1, -1);
        assert (!this.inHeap(n));
        this.indices.set(n, this.heap.size());
        this.heap.push(n);
        this.percolateUp(this.indices.get(n));
    }

    public int removeMin() {
        int x = this.heap.get(0);
        this.heap.set(0, this.heap.back());
        this.indices.set(this.heap.get(0), 0);
        this.indices.set(x, -1);
        this.heap.pop();
        if (this.heap.size() > 1) {
            this.percolateDown(0);
        }
        return x;
    }

    public void remove(int n) {
        assert (this.inHeap(n));
        int kPos = this.indices.get(n);
        this.indices.set(n, -1);
        if (kPos < this.heap.size() - 1) {
            this.heap.set(kPos, this.heap.back());
            this.indices.set(this.heap.get(kPos), kPos);
            this.heap.pop();
            this.percolateDown(kPos);
        } else {
            this.heap.pop();
        }
    }

    public void build(LNGIntVector ns) {
        int i;
        for (i = 0; i < this.heap.size(); ++i) {
            this.indices.set(this.heap.get(i), -1);
        }
        this.heap.clear();
        for (i = 0; i < ns.size(); ++i) {
            this.indices.set(ns.get(i), i);
            this.heap.push(ns.get(i));
        }
        for (i = this.heap.size() / 2 - 1; i >= 0; --i) {
            this.percolateDown(i);
        }
    }

    public void clear() {
        for (int i = 0; i < this.heap.size(); ++i) {
            this.indices.set(this.heap.get(i), -1);
        }
        this.heap.clear();
    }

    private void percolateUp(int pos) {
        int x = this.heap.get(pos);
        int p = LNGHeap.parent(pos);
        int j = pos;
        while (j != 0 && this.s.lt(x, this.heap.get(p))) {
            this.heap.set(j, this.heap.get(p));
            this.indices.set(this.heap.get(p), j);
            j = p;
            p = LNGHeap.parent(p);
        }
        this.heap.set(j, x);
        this.indices.set(x, j);
    }

    private void percolateDown(int pos) {
        int p = pos;
        int y = this.heap.get(p);
        while (LNGHeap.left(p) < this.heap.size()) {
            int child;
            int n = child = LNGHeap.right(p) < this.heap.size() && this.s.lt(this.heap.get(LNGHeap.right(p)), this.heap.get(LNGHeap.left(p))) ? LNGHeap.right(p) : LNGHeap.left(p);
            if (!this.s.lt(this.heap.get(child), y)) break;
            this.heap.set(p, this.heap.get(child));
            this.indices.set(this.heap.get(p), p);
            p = child;
        }
        this.heap.set(p, y);
        this.indices.set(y, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LNGHeap{");
        for (int i = 0; i < this.heap.size(); ++i) {
            sb.append("[").append(this.heap.get(i)).append(", ");
            sb.append(this.indices.get(i)).append("]");
            if (i == this.heap.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

