/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import org.logicng.collections.LNGLongVector;

public final class LNGBoundedLongQueue {
    private final LNGLongVector elems = new LNGLongVector();
    private int first = 0;
    private int last = 0;
    private long sumOfQueue = 0L;
    private int maxSize = 0;
    private int queueSize = 0;

    public void initSize(int size) {
        this.growTo(size);
    }

    public void push(long x) {
        if (this.queueSize == this.maxSize) {
            assert (this.last == this.first);
            this.sumOfQueue -= this.elems.get(this.last);
            if (++this.last == this.maxSize) {
                this.last = 0;
            }
        } else {
            ++this.queueSize;
        }
        this.sumOfQueue += x;
        this.elems.set(this.first, x);
        if (++this.first == this.maxSize) {
            this.first = 0;
            this.last = 0;
        }
    }

    public int avg() {
        return (int)(this.sumOfQueue / (long)this.queueSize);
    }

    public boolean valid() {
        return this.queueSize == this.maxSize;
    }

    private void growTo(int size) {
        this.elems.growTo(size, 0L);
        this.first = 0;
        this.maxSize = size;
        this.queueSize = 0;
        this.last = 0;
    }

    public void fastClear() {
        this.first = 0;
        this.last = 0;
        this.queueSize = 0;
        this.sumOfQueue = 0L;
    }

    public String toString() {
        return String.format("LNGBoundedLongQueue{first=%d, last=%d, sumOfQueue=%d, maxSize=%d, queueSize=%d, elems=%s}", this.first, this.last, this.sumOfQueue, this.maxSize, this.queueSize, this.elems);
    }
}

