/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.datastructures;

import org.logicng.collections.LNGIntVector;

public final class LNGBoundedIntQueue {
    private final LNGIntVector elems = new LNGIntVector();
    private int first = 0;
    private int last = 0;
    private long sumOfQueue = 0L;
    private int maxSize = 0;
    private int queueSize = 0;

    public void initSize(int size) {
        this.growTo(size);
    }

    public void push(int x) {
        if (this.queueSize == this.maxSize) {
            assert (this.last == this.first);
            this.sumOfQueue -= (long)this.elems.get(this.last);
            if (++this.last == this.maxSize) {
                this.last = 0;
            }
        } else {
            ++this.queueSize;
        }
        this.sumOfQueue += (long)x;
        this.elems.set(this.first, x);
        if (++this.first == this.maxSize) {
            this.first = 0;
            this.last = 0;
        }
    }

    public int avg() {
        return (int)(this.sumOfQueue / (long)this.queueSize);
    }

    private void growTo(int size) {
        this.elems.growTo(size, 0);
        this.first = 0;
        this.maxSize = size;
        this.queueSize = 0;
        this.last = 0;
    }

    public String toString() {
        return String.format("LNGBoundedIntQueue{first=%d, last=%d, sumOfQueue=%d, maxSize=%d, queueSize=%d, elems=%s}", this.first, this.last, this.sumOfQueue, this.maxSize, this.queueSize, this.elems);
    }
}

