/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneType;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.explanations.UNSATCore;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.BackboneFunction;
import org.logicng.solvers.functions.ModelEnumerationFunction;
import org.logicng.solvers.functions.SolverFunction;
import org.logicng.solvers.functions.UnsatCoreFunction;

public abstract class SATSolver {
    protected final FormulaFactory f;
    protected Tristate result;

    protected SATSolver(FormulaFactory f) {
        this.f = f;
    }

    public void add(Formula formula) {
        this.add(formula, null);
    }

    public abstract void add(Formula var1, Proposition var2);

    public abstract void addWithoutUnknown(Formula var1);

    public void addPropositions(Collection<? extends Proposition> propositions) {
        for (Proposition proposition : propositions) {
            this.add(proposition);
        }
    }

    public void addPropositions(Proposition ... propositions) {
        for (Proposition proposition : propositions) {
            this.add(proposition);
        }
    }

    public void add(Proposition proposition) {
        this.add(proposition.formula(), proposition);
    }

    public void add(Collection<? extends Formula> formulas) {
        for (Formula formula : formulas) {
            this.add(formula);
        }
    }

    public void addWithRelaxation(Variable relaxationVar, Formula formula) {
        this.addClauseSetWithRelaxation(relaxationVar, formula.cnf());
    }

    public void addWithRelaxation(Variable relaxationVar, Proposition proposition) {
        this.addWithRelaxation(relaxationVar, proposition.formula());
    }

    public void addWithRelaxation(Variable relaxationVar, Collection<? extends Formula> formulas) {
        for (Formula formula : formulas) {
            this.addWithRelaxation(relaxationVar, formula);
        }
    }

    public abstract CCIncrementalData addIncrementalCC(CardinalityConstraint var1);

    void addClauseSet(Formula formula, Proposition proposition) {
        switch (formula.type()) {
            case TRUE: {
                break;
            }
            case FALSE: 
            case LITERAL: 
            case OR: {
                this.addClause(formula, proposition);
                break;
            }
            case AND: {
                for (Formula op : formula) {
                    this.addClause(op, proposition);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Input formula ist not a valid CNF: " + formula);
            }
        }
    }

    protected void addClauseSetWithRelaxation(Variable relaxationVar, Formula formula) {
        switch (formula.type()) {
            case TRUE: {
                break;
            }
            case FALSE: 
            case LITERAL: 
            case OR: {
                this.addClauseWithRelaxation(relaxationVar, formula);
                break;
            }
            case AND: {
                for (Formula op : formula) {
                    this.addClauseWithRelaxation(relaxationVar, op);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Input formula ist not a valid CNF: " + formula);
            }
        }
    }

    protected abstract void addClause(Formula var1, Proposition var2);

    protected abstract void addClauseWithRelaxation(Variable var1, Formula var2);

    public Tristate sat() {
        return this.sat((SATHandler)null);
    }

    public abstract Tristate sat(SATHandler var1);

    public Tristate sat(Literal literal) {
        return this.sat(null, literal);
    }

    public Tristate sat(Collection<? extends Literal> assumptions) {
        return this.sat(null, assumptions);
    }

    public abstract Tristate sat(SATHandler var1, Literal var2);

    public abstract Tristate sat(SATHandler var1, Collection<? extends Literal> var2);

    public Tristate satWithSelectionOrder(List<? extends Literal> selectionOrder) {
        return this.satWithSelectionOrder(selectionOrder, null, null);
    }

    public Tristate satWithSelectionOrder(List<? extends Literal> selectionOrder, SATHandler handler, Collection<? extends Literal> assumptions) {
        this.setSolverToUndef();
        this.setSelectionOrder(selectionOrder);
        Tristate sat = assumptions != null ? this.sat(handler, assumptions) : this.sat(handler);
        this.resetSelectionOrder();
        return sat;
    }

    public abstract void reset();

    public Assignment model() {
        return this.model((Collection<Variable>)null);
    }

    public Assignment model(Variable[] variables) {
        return this.model(Arrays.asList(variables));
    }

    public abstract Assignment model(Collection<Variable> var1);

    public abstract <RESULT> RESULT execute(SolverFunction<RESULT> var1);

    public List<Assignment> enumerateAllModels() {
        return this.execute(ModelEnumerationFunction.builder().build());
    }

    public List<Assignment> enumerateAllModels(Collection<Variable> variables) {
        return this.execute(ModelEnumerationFunction.builder().variables(variables).build());
    }

    public List<Assignment> enumerateAllModels(Variable ... variables) {
        return this.execute(ModelEnumerationFunction.builder().variables(variables).build());
    }

    public abstract SolverState saveState();

    public abstract void loadState(SolverState var1);

    public void setSolverToUndef() {
        this.result = Tristate.UNDEF;
    }

    public abstract SortedSet<Variable> knownVariables();

    public UNSATCore<Proposition> unsatCore() {
        return this.execute(UnsatCoreFunction.get());
    }

    public Backbone backbone(Collection<Variable> relevantVariables) {
        return this.backbone(relevantVariables, BackboneType.POSITIVE_AND_NEGATIVE);
    }

    public Backbone backbone(Collection<Variable> relevantVariables, BackboneType type) {
        return this.execute(BackboneFunction.builder().variables(relevantVariables).type(type).build());
    }

    public FormulaFactory factory() {
        return this.f;
    }

    protected abstract void setSelectionOrder(List<? extends Literal> var1);

    protected abstract void resetSelectionOrder();
}

