/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.cardinalityconstraints.CCEncoder;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.EncodingResult;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CType;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.SolverFunction;
import org.logicng.solvers.sat.GlucoseConfig;
import org.logicng.solvers.sat.GlucoseSyrup;
import org.logicng.solvers.sat.MiniCard;
import org.logicng.solvers.sat.MiniSat2Solver;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;
import org.logicng.transformations.cnf.PlaistedGreenbaumTransformationSolver;

public final class MiniSat
extends SATSolver {
    protected final MiniSatConfig config;
    protected final MiniSatStyleSolver solver;
    protected final CCEncoder ccEncoder;
    protected final SolverStyle style;
    protected final LNGIntVector validStates;
    protected final boolean initialPhase;
    protected final boolean incremental;
    protected int nextStateId;
    protected final PlaistedGreenbaumTransformationSolver pgTransformation;
    protected final PlaistedGreenbaumTransformationSolver fullPgTransformation;
    protected boolean lastComputationWithAssumptions;

    protected MiniSat(FormulaFactory f, SolverStyle solverStyle, MiniSatConfig miniSatConfig, GlucoseConfig glucoseConfig) {
        super(f);
        this.config = miniSatConfig;
        this.style = solverStyle;
        this.initialPhase = miniSatConfig.initialPhase();
        switch (solverStyle) {
            case MINISAT: {
                this.solver = new MiniSat2Solver(miniSatConfig);
                break;
            }
            case GLUCOSE: {
                this.solver = new GlucoseSyrup(miniSatConfig, glucoseConfig);
                break;
            }
            case MINICARD: {
                this.solver = new MiniCard(miniSatConfig);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown solver style: " + (Object)((Object)solverStyle));
            }
        }
        this.result = Tristate.UNDEF;
        this.incremental = miniSatConfig.incremental();
        this.validStates = new LNGIntVector();
        this.nextStateId = 0;
        this.ccEncoder = new CCEncoder(f);
        this.pgTransformation = new PlaistedGreenbaumTransformationSolver(true, this.underlyingSolver(), this.initialPhase);
        this.fullPgTransformation = new PlaistedGreenbaumTransformationSolver(false, this.underlyingSolver(), this.initialPhase);
    }

    public static MiniSat miniSat(FormulaFactory f) {
        return new MiniSat(f, SolverStyle.MINISAT, MiniSatConfig.builder().build(), null);
    }

    public static MiniSat miniSat(FormulaFactory f, MiniSatConfig config) {
        return new MiniSat(f, SolverStyle.MINISAT, config, null);
    }

    public static MiniSat glucose(FormulaFactory f) {
        return new MiniSat(f, SolverStyle.GLUCOSE, MiniSatConfig.builder().build(), GlucoseConfig.builder().build());
    }

    public static MiniSat glucose(FormulaFactory f, MiniSatConfig miniSatConfig, GlucoseConfig glucoseConfig) {
        return new MiniSat(f, SolverStyle.GLUCOSE, miniSatConfig, glucoseConfig);
    }

    public static MiniSat miniCard(FormulaFactory f) {
        return new MiniSat(f, SolverStyle.MINICARD, MiniSatConfig.builder().build(), null);
    }

    public static MiniSat miniCard(FormulaFactory f, MiniSatConfig config) {
        return new MiniSat(f, SolverStyle.MINICARD, config, null);
    }

    @Override
    public void add(Formula formula, Proposition proposition) {
        this.result = Tristate.UNDEF;
        if (formula.type() == FType.PBC) {
            PBConstraint constraint = (PBConstraint)formula;
            if (constraint.isCC()) {
                if (this.style == SolverStyle.MINICARD) {
                    if (constraint.comparator() == CType.LE) {
                        ((MiniCard)this.solver).addAtMost(this.generateClauseVector(Arrays.asList(constraint.operands())), constraint.rhs());
                    } else if (constraint.comparator() == CType.LT && constraint.rhs() > 3) {
                        ((MiniCard)this.solver).addAtMost(this.generateClauseVector(Arrays.asList(constraint.operands())), constraint.rhs() - 1);
                    } else if (constraint.comparator() == CType.EQ && constraint.rhs() == 1) {
                        ((MiniCard)this.solver).addAtMost(this.generateClauseVector(Arrays.asList(constraint.operands())), constraint.rhs());
                        this.solver.addClause(this.generateClauseVector(Arrays.asList(constraint.operands())), proposition);
                    } else {
                        this.addFormulaAsCNF(constraint, proposition);
                    }
                } else {
                    EncodingResult result = EncodingResult.resultForMiniSat(this.f, this, proposition);
                    this.ccEncoder.encode((CardinalityConstraint)constraint, result);
                }
            } else {
                this.addFormulaAsCNF(constraint, proposition);
            }
        } else {
            this.addFormulaAsCNF(formula, proposition);
        }
    }

    protected void addFormulaAsCNF(Formula formula, Proposition proposition) {
        if (this.config.getCnfMethod() == MiniSatConfig.CNFMethod.FACTORY_CNF) {
            this.addClauseSet(formula.cnf(), proposition);
        } else if (this.config.getCnfMethod() == MiniSatConfig.CNFMethod.PG_ON_SOLVER) {
            this.pgTransformation.addCNFtoSolver(formula, proposition);
        } else if (this.config.getCnfMethod() == MiniSatConfig.CNFMethod.FULL_PG_ON_SOLVER) {
            this.fullPgTransformation.addCNFtoSolver(formula, proposition);
        } else {
            throw new IllegalStateException("Unknown Solver CNF method: " + (Object)((Object)this.config.getCnfMethod()));
        }
    }

    @Override
    public void addWithoutUnknown(Formula formula) {
        int nVars = this.solver.nVars();
        Assignment restriction = new Assignment(true);
        Map<String, Integer> map = this.solver.name2idx();
        for (Variable var : formula.variables()) {
            Integer index = map.get(var.name());
            if (index != null && index < nVars) continue;
            restriction.addLiteral(var.negate());
        }
        this.add(formula.restrict(restriction));
    }

    @Override
    public CCIncrementalData addIncrementalCC(CardinalityConstraint cc) {
        EncodingResult result = EncodingResult.resultForMiniSat(this.f, this, null);
        return this.ccEncoder.encodeIncremental(cc, result);
    }

    @Override
    protected void addClause(Formula formula, Proposition proposition) {
        this.result = Tristate.UNDEF;
        LNGIntVector ps = this.generateClauseVector(formula.literals());
        this.solver.addClause(ps, proposition);
    }

    @Override
    protected void addClauseWithRelaxation(Variable relaxationVar, Formula formula) {
        this.result = Tristate.UNDEF;
        TreeSet<Literal> literals = new TreeSet<Literal>(formula.literals());
        literals.add(relaxationVar);
        this.solver.addClause(this.generateClauseVector(literals), null);
    }

    @Override
    public Tristate sat(SATHandler handler) {
        if (this.lastResultIsUsable()) {
            return this.result;
        }
        this.result = this.solver.solve(handler);
        this.lastComputationWithAssumptions = false;
        return this.result;
    }

    @Override
    public Tristate sat(SATHandler handler, Literal literal) {
        LNGIntVector clauseVec = new LNGIntVector(1);
        int index = this.getOrAddIndex(literal);
        int litNum = literal.phase() ? index * 2 : index * 2 ^ 1;
        clauseVec.push(litNum);
        this.result = this.solver.solve(handler, clauseVec);
        this.lastComputationWithAssumptions = true;
        return this.result;
    }

    @Override
    public Tristate sat(SATHandler handler, Collection<? extends Literal> assumptions) {
        LNGIntVector assumptionVec = this.generateClauseVector(assumptions);
        this.result = this.solver.solve(handler, assumptionVec);
        this.lastComputationWithAssumptions = true;
        return this.result;
    }

    @Override
    public void reset() {
        this.solver.reset();
        this.lastComputationWithAssumptions = false;
        this.pgTransformation.clearCache();
        this.fullPgTransformation.clearCache();
        this.result = Tristate.UNDEF;
    }

    @Override
    public Assignment model(Collection<Variable> variables) {
        LNGIntVector relevantIndices;
        if (this.result == Tristate.UNDEF) {
            throw new IllegalStateException("Cannot get a model as long as the formula is not solved.  Call 'sat' first.");
        }
        LNGIntVector lNGIntVector = relevantIndices = variables == null ? null : new LNGIntVector(variables.size());
        if (relevantIndices != null) {
            for (Variable var : variables) {
                relevantIndices.push(this.solver.idxForName(var.name()));
            }
        }
        return this.result == Tristate.TRUE ? this.createAssignment(this.solver.model(), relevantIndices) : null;
    }

    @Override
    public <RESULT> RESULT execute(SolverFunction<RESULT> function) {
        return function.apply(this, this::setResult);
    }

    @Override
    public SolverState saveState() {
        int id = this.nextStateId++;
        this.validStates.push(id);
        return new SolverState(id, this.solver.saveState());
    }

    @Override
    public void loadState(SolverState state) {
        int index = -1;
        for (int i = this.validStates.size() - 1; i >= 0 && index == -1; --i) {
            if (this.validStates.get(i) != state.id()) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("The given solver state is not valid anymore.");
        }
        this.validStates.shrinkTo(index + 1);
        this.solver.loadState(state.state());
        this.result = Tristate.UNDEF;
        this.pgTransformation.clearCache();
        this.fullPgTransformation.clearCache();
    }

    @Override
    public SortedSet<Variable> knownVariables() {
        TreeSet<Variable> result = new TreeSet<Variable>();
        int nVars = this.solver.nVars();
        for (Map.Entry<String, Integer> entry : this.solver.name2idx().entrySet()) {
            if (entry.getValue() >= nVars) continue;
            result.add(this.f.variable(entry.getKey()));
        }
        return result;
    }

    protected LNGIntVector generateClauseVector(Collection<? extends Literal> literals) {
        LNGIntVector clauseVec = new LNGIntVector(literals.size());
        for (Literal literal : literals) {
            int index = this.getOrAddIndex(literal);
            int litNum = literal.phase() ? index * 2 : index * 2 ^ 1;
            clauseVec.push(litNum);
        }
        return clauseVec;
    }

    protected int getOrAddIndex(Literal lit) {
        int index = this.solver.idxForName(lit.name());
        if (index == -1) {
            index = this.solver.newVar(!this.initialPhase, true);
            this.solver.addName(lit.name(), index);
        }
        return index;
    }

    public Assignment createAssignment(LNGBooleanVector vec, LNGIntVector relevantIndices) {
        Assignment model = new Assignment();
        if (relevantIndices == null) {
            for (int i = 0; i < vec.size(); ++i) {
                String name = this.solver.nameForIdx(i);
                if (!this.isRelevantVariable(name)) continue;
                model.addLiteral(this.f.literal(name, vec.get(i)));
            }
        } else {
            for (int i = 0; i < relevantIndices.size(); ++i) {
                String name;
                int index = relevantIndices.get(i);
                if (index == -1 || !this.isRelevantVariable(name = this.solver.nameForIdx(index))) continue;
                model.addLiteral(this.f.literal(name, vec.get(index)));
            }
        }
        return model;
    }

    public boolean isRelevantVariable(String name) {
        return this.config.isAuxiliaryVariablesInModels() || !name.startsWith("@RESERVED_CNF_") && !name.startsWith("@RESERVED_CC_") && !name.startsWith("@RESERVED_PB_");
    }

    public MiniSatStyleSolver underlyingSolver() {
        return this.solver;
    }

    public boolean initialPhase() {
        return this.initialPhase;
    }

    public String toString() {
        return String.format("%s{result=%s, incremental=%s}", new Object[]{this.solver.getClass().getSimpleName(), this.result, this.incremental});
    }

    protected boolean lastResultIsUsable() {
        return this.result != Tristate.UNDEF && !this.lastComputationWithAssumptions;
    }

    public MiniSatConfig getConfig() {
        return this.config;
    }

    @Override
    public void setSelectionOrder(List<? extends Literal> selectionOrder) {
        this.solver.setSelectionOrder(selectionOrder);
    }

    @Override
    public void resetSelectionOrder() {
        this.solver.resetSelectionOrder();
    }

    public SolverStyle getStyle() {
        return this.style;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public Tristate getResult() {
        return this.result;
    }

    protected void setResult(Tristate tristate) {
        this.result = tristate;
    }

    public boolean isLastComputationWithAssumptions() {
        return this.lastComputationWithAssumptions;
    }

    public static enum SolverStyle {
        MINISAT,
        GLUCOSE,
        MINICARD;

    }
}

