/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers;

import java.util.SortedMap;
import java.util.TreeMap;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.handlers.MaxSATHandler;
import org.logicng.solvers.maxsat.algorithms.IncWBO;
import org.logicng.solvers.maxsat.algorithms.LinearSU;
import org.logicng.solvers.maxsat.algorithms.LinearUS;
import org.logicng.solvers.maxsat.algorithms.MSU3;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.algorithms.WBO;
import org.logicng.solvers.maxsat.algorithms.WMSU3;

public class MaxSATSolver {
    protected final MaxSATConfig configuration;
    protected final Algorithm algorithm;
    protected MaxSAT.MaxSATResult result;
    protected MaxSAT solver;
    protected SortedMap<Variable, Integer> var2index;
    protected SortedMap<Integer, Variable> index2var;

    protected MaxSATSolver(MaxSATConfig configuration, Algorithm algorithm) {
        this.algorithm = algorithm;
        this.configuration = configuration;
        this.reset();
    }

    public static MaxSATSolver incWBO() {
        return new MaxSATSolver(MaxSATConfig.builder().build(), Algorithm.INC_WBO);
    }

    public static MaxSATSolver incWBO(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.INC_WBO);
    }

    public static MaxSATSolver linearSU() {
        return new MaxSATSolver(MaxSATConfig.builder().cardinality(MaxSATConfig.CardinalityEncoding.MTOTALIZER).build(), Algorithm.LINEAR_SU);
    }

    public static MaxSATSolver linearSU(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.LINEAR_SU);
    }

    public static MaxSATSolver linearUS() {
        return new MaxSATSolver(MaxSATConfig.builder().build(), Algorithm.LINEAR_US);
    }

    public static MaxSATSolver linearUS(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.LINEAR_US);
    }

    public static MaxSATSolver msu3() {
        return new MaxSATSolver(MaxSATConfig.builder().build(), Algorithm.MSU3);
    }

    public static MaxSATSolver msu3(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.MSU3);
    }

    public static MaxSATSolver wbo() {
        return new MaxSATSolver(MaxSATConfig.builder().build(), Algorithm.WBO);
    }

    public static MaxSATSolver wbo(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.WBO);
    }

    public static MaxSATSolver wmsu3() {
        return new MaxSATSolver(MaxSATConfig.builder().incremental(MaxSATConfig.IncrementalStrategy.ITERATIVE).build(), Algorithm.WMSU3);
    }

    public static MaxSATSolver wmsu3(MaxSATConfig config) {
        return new MaxSATSolver(config, Algorithm.WMSU3);
    }

    public void reset() {
        this.result = MaxSAT.MaxSATResult.UNDEF;
        this.var2index = new TreeMap<Variable, Integer>();
        this.index2var = new TreeMap<Integer, Variable>();
        switch (this.algorithm) {
            case WBO: {
                this.solver = new WBO(this.configuration);
                break;
            }
            case INC_WBO: {
                this.solver = new IncWBO(this.configuration);
                break;
            }
            case LINEAR_SU: {
                this.solver = new LinearSU(this.configuration);
                break;
            }
            case LINEAR_US: {
                this.solver = new LinearUS(this.configuration);
                break;
            }
            case MSU3: {
                this.solver = new MSU3(this.configuration);
                break;
            }
            case WMSU3: {
                this.solver = new WMSU3(this.configuration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown MaxSAT algorithm: " + (Object)((Object)this.algorithm));
            }
        }
    }

    public void addHardFormula(Formula formula) {
        if (this.result != MaxSAT.MaxSATResult.UNDEF) {
            throw new IllegalStateException("The MaxSAT solver does currently not support an incremental interface.  Reset the solver.");
        }
        this.addCNF(formula.cnf(), -1);
    }

    public void addSoftFormula(Formula formula, int weight) {
        if (this.result != MaxSAT.MaxSATResult.UNDEF) {
            throw new IllegalStateException("The MaxSAT solver does currently not support an incremental interface.  Reset the solver.");
        }
        if (weight < 1) {
            throw new IllegalArgumentException("The weight of a formula must be > 0");
        }
        this.addCNF(formula.cnf(), weight);
    }

    protected void addCNF(Formula formula, int weight) {
        switch (formula.type()) {
            case TRUE: {
                break;
            }
            case FALSE: 
            case LITERAL: 
            case OR: {
                this.addClause(formula, weight);
                break;
            }
            case AND: {
                for (Formula op : formula) {
                    this.addClause(op, weight);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Input formula ist not a valid CNF: " + formula);
            }
        }
    }

    protected void addClause(Formula formula, int weight) {
        this.result = MaxSAT.MaxSATResult.UNDEF;
        LNGIntVector clauseVec = new LNGIntVector((int)formula.numberOfAtoms());
        for (Literal lit : formula.literals()) {
            Integer index = (Integer)this.var2index.get(lit.variable());
            if (index == null) {
                index = this.solver.newLiteral(false) >> 1;
                this.var2index.put(lit.variable(), index);
                this.index2var.put(index, lit.variable());
            }
            int litNum = lit.phase() ? index * 2 : index * 2 ^ 1;
            clauseVec.push(litNum);
        }
        if (weight == -1) {
            this.solver.addHardClause(clauseVec);
        } else {
            this.solver.setCurrentWeight(weight);
            this.solver.updateSumWeights(weight);
            this.solver.addSoftClause(weight, clauseVec);
        }
    }

    public MaxSAT.MaxSATResult solve() {
        return this.solve(null);
    }

    public MaxSAT.MaxSATResult solve(MaxSATHandler handler) {
        if (this.result != MaxSAT.MaxSATResult.UNDEF) {
            return this.result;
        }
        if (this.solver.currentWeight() == 1) {
            this.solver.setProblemType(MaxSAT.ProblemType.UNWEIGHTED);
        } else {
            this.solver.setProblemType(MaxSAT.ProblemType.WEIGHTED);
        }
        this.result = this.solver.search(handler);
        return this.result;
    }

    public int result() {
        if (this.result == MaxSAT.MaxSATResult.UNDEF) {
            throw new IllegalStateException("Cannot get a result as long as the formula is not solved.  Call 'solver' first.");
        }
        return this.result == MaxSAT.MaxSATResult.OPTIMUM ? this.solver.result() : -1;
    }

    public Assignment model() {
        if (this.result == MaxSAT.MaxSATResult.UNDEF) {
            throw new IllegalStateException("Cannot get a model as long as the formula is not solved.  Call 'solver' first.");
        }
        return this.result != MaxSAT.MaxSATResult.UNSATISFIABLE ? this.createAssignment(this.solver.model()) : null;
    }

    protected Assignment createAssignment(LNGBooleanVector vec) {
        Assignment model = new Assignment();
        for (int i = 0; i < vec.size(); ++i) {
            Literal lit = (Literal)this.index2var.get(i);
            if (lit == null) continue;
            if (vec.get(i)) {
                model.addLiteral(lit);
                continue;
            }
            model.addLiteral(lit.negate());
        }
        return model;
    }

    public MaxSAT.Stats stats() {
        return this.solver.stats();
    }

    public String toString() {
        return String.format("MaxSATSolver{result=%s, var2index=%s}", new Object[]{this.result, this.var2index});
    }

    protected static enum Algorithm {
        WBO,
        INC_WBO,
        LINEAR_SU,
        LINEAR_US,
        MSU3,
        WMSU3;

    }
}

