/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.pseudobooleans;

import java.util.List;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.pseudobooleans.PBEncoding;

public final class PBSWC
implements PBEncoding {
    private final FormulaFactory f;

    PBSWC(FormulaFactory f) {
        this.f = f;
    }

    @Override
    public List<Formula> encode(LNGVector<Literal> lits, LNGIntVector coeffs, int rhs, List<Formula> result) {
        this.generateConstraint(rhs, lits, coeffs, result);
        return result;
    }

    private void generateConstraint(int rhs, LNGVector<Literal> lits, LNGIntVector coeffs, List<Formula> result) {
        int i;
        int n = lits.size();
        LNGVector seqAuxiliary = new LNGVector(n + 1);
        for (i = 0; i < n + 1; ++i) {
            LNGVector temp = new LNGVector();
            temp.growTo(rhs + 1);
            seqAuxiliary.push(temp);
        }
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= rhs; ++j) {
                ((LNGVector)seqAuxiliary.get(i)).set(j, this.f.newPBVariable());
            }
        }
        for (i = 1; i <= n; ++i) {
            int wi = coeffs.get(i - 1);
            assert (wi <= rhs);
            for (int j = 1; j <= rhs; ++j) {
                if (i >= 2 && i <= n && j <= rhs) {
                    result.add(this.f.clause(((Literal)((LNGVector)seqAuxiliary.get(i - 1)).get(j)).negate(), (Literal)((LNGVector)seqAuxiliary.get(i)).get(j)));
                }
                if (i <= n && j <= wi) {
                    result.add(this.f.clause(lits.get(i - 1).negate(), (Literal)((LNGVector)seqAuxiliary.get(i)).get(j)));
                }
                if (i < 2 || i > n || j > rhs - wi) continue;
                result.add(this.f.clause(((Literal)((LNGVector)seqAuxiliary.get(i - 1)).get(j)).negate(), lits.get(i - 1).negate(), (Literal)((LNGVector)seqAuxiliary.get(i)).get(j + wi)));
            }
            if (i < 2) continue;
            result.add(this.f.clause(((Literal)((LNGVector)seqAuxiliary.get(i - 1)).get(rhs + 1 - wi)).negate(), lits.get(i - 1).negate()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

