/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.pseudobooleans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.cardinalityconstraints.CCEncoder;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.PBConstraint;
import org.logicng.pseudobooleans.PBAdderNetworks;
import org.logicng.pseudobooleans.PBBinaryMerge;
import org.logicng.pseudobooleans.PBConfig;
import org.logicng.pseudobooleans.PBSWC;

public class PBEncoder {
    protected final FormulaFactory f;
    protected final PBConfig config;
    protected final PBConfig defaultConfig;
    protected final CCEncoder ccEncoder;
    protected PBSWC swc;
    protected PBAdderNetworks adderNetworks;

    public PBEncoder(FormulaFactory f, PBConfig pbConfig, CCConfig ccConfig) {
        this.f = f;
        this.defaultConfig = PBConfig.builder().build();
        this.config = pbConfig;
        this.ccEncoder = new CCEncoder(f, ccConfig);
    }

    public PBEncoder(FormulaFactory f, PBConfig pbConfig) {
        this.f = f;
        this.defaultConfig = PBConfig.builder().build();
        this.config = pbConfig;
        this.ccEncoder = new CCEncoder(f);
    }

    public PBEncoder(FormulaFactory f) {
        this.f = f;
        this.defaultConfig = PBConfig.builder().build();
        this.config = null;
        this.ccEncoder = new CCEncoder(f);
    }

    public List<Formula> encode(PBConstraint constraint) {
        if (constraint.isCC()) {
            return this.ccEncoder.encode((CardinalityConstraint)constraint);
        }
        Formula normalized = constraint.normalize();
        switch (normalized.type()) {
            case TRUE: {
                return Collections.emptyList();
            }
            case FALSE: {
                return Collections.singletonList(this.f.falsum());
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)normalized;
                if (pbc.isCC()) {
                    return this.ccEncoder.encode((CardinalityConstraint)pbc);
                }
                return this.encode(pbc.operands(), pbc.coefficients(), pbc.rhs());
            }
            case AND: {
                ArrayList<Formula> list = new ArrayList<Formula>();
                block10: for (Formula op : normalized) {
                    switch (op.type()) {
                        case FALSE: {
                            return Collections.singletonList(this.f.falsum());
                        }
                        case PBC: {
                            list.addAll(this.encode((PBConstraint)op));
                            continue block10;
                        }
                    }
                    throw new IllegalArgumentException("Illegal return value of PBConstraint.normalize");
                }
                return Collections.unmodifiableList(list);
            }
        }
        throw new IllegalArgumentException("Illegal return value of PBConstraint.normalize");
    }

    public PBConfig config() {
        if (this.config != null) {
            return this.config;
        }
        Configuration pbConfig = this.f.configurationFor(ConfigurationType.PB_ENCODER);
        return pbConfig != null ? (PBConfig)pbConfig : this.defaultConfig;
    }

    protected List<Formula> encode(Literal[] lits, int[] coeffs, int rhs) {
        if (rhs == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Overflow in the Encoding");
        }
        if (rhs < 0) {
            return Collections.singletonList(this.f.falsum());
        }
        LNGVector<Literal> simplifiedLits = new LNGVector<Literal>();
        LNGIntVector simplifiedCoeffs = new LNGIntVector();
        ArrayList<Formula> result = new ArrayList<Formula>();
        if (rhs == 0) {
            for (Literal lit : lits) {
                result.add(lit.negate());
            }
            return result;
        }
        for (int i = 0; i < lits.length; ++i) {
            if (coeffs[i] <= rhs) {
                simplifiedLits.push(lits[i]);
                simplifiedCoeffs.push(coeffs[i]);
                continue;
            }
            result.add(lits[i].negate());
        }
        if (simplifiedLits.size() <= 1) {
            return result;
        }
        switch (this.config().pbEncoder) {
            case SWC: 
            case BEST: {
                if (this.swc == null) {
                    this.swc = new PBSWC(this.f);
                }
                return this.swc.encode(simplifiedLits, simplifiedCoeffs, rhs, result);
            }
            case BINARY_MERGE: {
                return new PBBinaryMerge(this.f, this.config()).encode(simplifiedLits, simplifiedCoeffs, rhs, result);
            }
            case ADDER_NETWORKS: {
                if (this.adderNetworks == null) {
                    this.adderNetworks = new PBAdderNetworks(this.f);
                }
                return this.adderNetworks.encode(simplifiedLits, simplifiedCoeffs, rhs, result);
            }
        }
        throw new IllegalStateException("Unknown pseudo-Boolean encoder: " + (Object)((Object)this.config().pbEncoder));
    }
}

