/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.pseudobooleans;

import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class PBConfig
extends Configuration {
    final PB_ENCODER pbEncoder;
    final boolean binaryMergeUseGAC;
    final boolean binaryMergeNoSupportForSingleBit;
    final boolean binaryMergeUseWatchDog;

    private PBConfig(Builder builder) {
        super(ConfigurationType.PB_ENCODER);
        this.pbEncoder = builder.pbEncoder;
        this.binaryMergeUseGAC = builder.binaryMergeUseGAC;
        this.binaryMergeNoSupportForSingleBit = builder.binaryMergeNoSupportForSingleBit;
        this.binaryMergeUseWatchDog = builder.binaryMergeUseWatchDog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PBConfig{").append(System.lineSeparator());
        sb.append("pbEncoder=").append((Object)this.pbEncoder).append(System.lineSeparator());
        sb.append("binaryMergeUseGAC=").append(this.binaryMergeUseGAC).append(System.lineSeparator());
        sb.append("binaryMergeNoSupportForSingleBit=").append(this.binaryMergeNoSupportForSingleBit).append(System.lineSeparator());
        sb.append("binaryMergeUseWatchDog=").append(this.binaryMergeUseWatchDog).append(System.lineSeparator());
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public static class Builder {
        private PB_ENCODER pbEncoder = PB_ENCODER.BEST;
        private boolean binaryMergeUseGAC = true;
        private boolean binaryMergeNoSupportForSingleBit = false;
        private boolean binaryMergeUseWatchDog = true;

        private Builder() {
        }

        public Builder pbEncoding(PB_ENCODER pbEncoder) {
            this.pbEncoder = pbEncoder;
            return this;
        }

        public Builder binaryMergeUseGAC(boolean binaryMergeUseGAC) {
            this.binaryMergeUseGAC = binaryMergeUseGAC;
            return this;
        }

        public Builder binaryMergeNoSupportForSingleBit(boolean binaryMergeNoSupportForSingleBit) {
            this.binaryMergeNoSupportForSingleBit = binaryMergeNoSupportForSingleBit;
            return this;
        }

        public Builder binaryMergeUseWatchDog(boolean binaryMergeUseWatchDog) {
            this.binaryMergeUseWatchDog = binaryMergeUseWatchDog;
            return this;
        }

        public PBConfig build() {
            return new PBConfig(this);
        }
    }

    public static enum PB_ENCODER {
        SWC,
        BINARY_MERGE,
        ADDER_NETWORKS,
        BEST;

    }
}

