/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.pseudobooleans;

import java.util.List;
import org.logicng.cardinalityconstraints.CCSorting;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.pseudobooleans.PBConfig;
import org.logicng.pseudobooleans.PBEncoding;

public final class PBBinaryMerge
implements PBEncoding {
    private final FormulaFactory f;
    private final PBConfig config;
    private final CCSorting sorting;

    PBBinaryMerge(FormulaFactory f, PBConfig config) {
        this.f = f;
        this.config = config;
        this.sorting = new CCSorting();
    }

    @Override
    public List<Formula> encode(LNGVector<Literal> lts, LNGIntVector cffs, int rhs, List<Formula> formula) {
        LNGVector<Literal> lits = new LNGVector<Literal>(lts.size());
        for (Literal lit : lts) {
            lits.push(lit);
        }
        LNGIntVector coeffs = new LNGIntVector(cffs);
        int maxWeight = this.maxWeight(coeffs);
        if (!this.config.binaryMergeUseGAC) {
            this.binary_merge(lts, new LNGIntVector(cffs), rhs, maxWeight, lits.size(), formula, null);
        } else {
            boolean encode_complete_constraint = false;
            for (int i = 0; i < lits.size(); ++i) {
                if (this.config.binaryMergeNoSupportForSingleBit && Double.compare(Math.floor(Math.log(coeffs.get(i)) / Math.log(2.0)), Math.log(coeffs.get(i)) / Math.log(2.0)) == 0) {
                    encode_complete_constraint = true;
                    continue;
                }
                Literal tmpLit = (Literal)lits.get(i);
                int tmpCoeff = coeffs.get(i);
                lits.set(i, (Literal)lits.back());
                coeffs.set(i, coeffs.back());
                lits.pop();
                coeffs.pop();
                Literal x = tmpLit;
                if (maxWeight == tmpCoeff) {
                    int j;
                    int mw = 0;
                    for (j = 0; j < coeffs.size(); ++j) {
                        mw = Math.max(mw, coeffs.get(j));
                    }
                    if (rhs - tmpCoeff <= 0) {
                        for (j = 0; j < lits.size(); ++j) {
                            formula.add(this.f.clause(x.negate(), lits.get(j).negate()));
                        }
                    } else {
                        this.binary_merge(lits, coeffs, rhs - tmpCoeff, mw, lits.size(), formula, x.negate());
                    }
                } else {
                    if (rhs - tmpCoeff <= 0) {
                        for (int j = 0; j < lits.size(); ++j) {
                            formula.add(this.f.clause(x.negate(), lits.get(j).negate()));
                        }
                    }
                    this.binary_merge(lits, coeffs, rhs - tmpCoeff, maxWeight, lits.size(), formula, x.negate());
                }
                if (i >= lits.size()) continue;
                lits.push(lits.get(i));
                lits.set(i, tmpLit);
                coeffs.push(coeffs.get(i));
                coeffs.set(i, tmpCoeff);
            }
            if (this.config.binaryMergeNoSupportForSingleBit && encode_complete_constraint) {
                this.binary_merge(lts, new LNGIntVector(cffs), rhs, maxWeight, lits.size(), formula, null);
            }
        }
        return formula;
    }

    private int maxWeight(LNGIntVector weights) {
        int maxweight = Integer.MIN_VALUE;
        for (int i = 0; i < weights.size(); ++i) {
            if (weights.get(i) <= maxweight) continue;
            maxweight = weights.get(i);
        }
        return maxweight;
    }

    private void binary_merge(LNGVector<Literal> literals, LNGIntVector coefficients, int leq, int maxWeight, int n, List<Formula> formula, Literal gac_lit) {
        int less_then = leq + 1;
        int p = (int)Math.floor(Math.log(maxWeight) / Math.log(2.0));
        int m = (int)Math.ceil((double)less_then / Math.pow(2.0, p));
        int new_less_then = (int)((double)m * Math.pow(2.0, p));
        int T = (int)((double)m * Math.pow(2.0, p) - (double)less_then);
        Variable true_lit = this.f.newPBVariable();
        formula.add(true_lit);
        LNGVector buckets = new LNGVector();
        int bit = 1;
        for (int i = 0; i <= p; ++i) {
            buckets.push(new LNGVector());
            if ((T & bit) != 0) {
                ((LNGVector)buckets.get(i)).push(true_lit);
            }
            for (int j = 0; j < n; ++j) {
                if ((coefficients.get(j) & bit) == 0) continue;
                if (gac_lit != null && coefficients.get(j) >= less_then) {
                    formula.add(this.f.clause(gac_lit, literals.get(j).negate()));
                    continue;
                }
                ((LNGVector)buckets.get(i)).push(literals.get(j));
            }
            bit <<= 1;
        }
        LNGVector bucket_card = new LNGVector(p + 1);
        LNGVector bucket_merge = new LNGVector(p + 1);
        for (int i = 0; i < p + 1; ++i) {
            bucket_card.push(new LNGVector());
            bucket_merge.push(new LNGVector());
        }
        assert (bucket_card.size() == buckets.size());
        LNGVector<Literal> carries = new LNGVector<Literal>();
        EncodingResult tempResul = EncodingResult.resultForFormula(this.f);
        for (int i = 0; i < buckets.size(); ++i) {
            int j;
            int k = (int)Math.ceil((double)new_less_then / Math.pow(2.0, i));
            if (this.config.binaryMergeUseWatchDog) {
                this.totalizer((LNGVector)buckets.get(i), (LNGVector)bucket_card.get(i), formula);
            } else {
                this.sorting.sort(k, (LNGVector)buckets.get(i), tempResul, (LNGVector)bucket_card.get(i), CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
                formula.addAll(tempResul.result());
            }
            if (k <= ((LNGVector)buckets.get(i)).size()) {
                assert (k == ((LNGVector)bucket_card.get(i)).size() || this.config.binaryMergeUseWatchDog);
                if (gac_lit != null) {
                    formula.add(this.f.clause(gac_lit, ((Literal)((LNGVector)bucket_card.get(i)).get(k - 1)).negate()));
                } else {
                    formula.add(this.f.clause(((Literal)((LNGVector)bucket_card.get(i)).get(k - 1)).negate()));
                }
            }
            if (i > 0) {
                if (carries.size() > 0) {
                    if (((LNGVector)bucket_card.get(i)).size() == 0) {
                        bucket_merge.set(i, carries);
                    } else {
                        if (this.config.binaryMergeUseWatchDog) {
                            this.unary_adder((LNGVector)bucket_card.get(i), carries, (LNGVector)bucket_merge.get(i), formula);
                        } else {
                            this.sorting.merge(k, (LNGVector)bucket_card.get(i), carries, tempResul, (LNGVector)bucket_merge.get(i), CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
                            formula.addAll(tempResul.result());
                        }
                        if (k == ((LNGVector)bucket_merge.get(i)).size() || this.config.binaryMergeUseWatchDog && k <= ((LNGVector)bucket_merge.get(i)).size()) {
                            if (gac_lit != null) {
                                formula.add(this.f.clause(gac_lit, ((Literal)((LNGVector)bucket_merge.get(i)).get(k - 1)).negate()));
                            } else {
                                formula.add(this.f.clause(((Literal)((LNGVector)bucket_merge.get(i)).get(k - 1)).negate()));
                            }
                        }
                    }
                } else {
                    ((LNGVector)bucket_merge.get(i)).replaceInplace((LNGVector)bucket_card.get(i));
                }
            }
            carries.clear();
            if (i == 0) {
                for (j = 1; j < ((LNGVector)bucket_card.get(0)).size(); j += 2) {
                    carries.push((Literal)((LNGVector)bucket_card.get(0)).get(j));
                }
                continue;
            }
            for (j = 1; j < ((LNGVector)bucket_merge.get(i)).size(); j += 2) {
                carries.push((Literal)((LNGVector)bucket_merge.get(i)).get(j));
            }
        }
    }

    private void totalizer(LNGVector<Literal> x, LNGVector<Literal> u_x, List<Formula> formula) {
        u_x.clear();
        if (x.size() == 0) {
            return;
        }
        if (x.size() == 1) {
            u_x.push(x.get(0));
        } else {
            int i;
            for (int i2 = 0; i2 < x.size(); ++i2) {
                u_x.push(this.f.newPBVariable());
            }
            LNGVector<Literal> x_1 = new LNGVector<Literal>();
            LNGVector<Literal> x_2 = new LNGVector<Literal>();
            for (i = 0; i < x.size() / 2; ++i) {
                x_1.push(x.get(i));
            }
            while (i < x.size()) {
                x_2.push(x.get(i));
                ++i;
            }
            LNGVector<Literal> u_x_1 = new LNGVector<Literal>();
            LNGVector<Literal> u_x_2 = new LNGVector<Literal>();
            this.totalizer(x_1, u_x_1, formula);
            this.totalizer(x_2, u_x_2, formula);
            this.unary_adder(u_x_1, u_x_2, u_x, formula);
        }
    }

    private void unary_adder(LNGVector<Literal> u, LNGVector<Literal> v, LNGVector<Literal> w, List<Formula> formula) {
        w.clear();
        if (u.size() == 0) {
            for (int i = 0; i < v.size(); ++i) {
                w.push(v.get(i));
            }
        } else if (v.size() == 0) {
            for (int i = 0; i < u.size(); ++i) {
                w.push(u.get(i));
            }
        } else {
            int i;
            for (i = 0; i < u.size() + v.size(); ++i) {
                w.push(this.f.newPBVariable());
            }
            for (int a = 0; a < u.size(); ++a) {
                for (int b = 0; b < v.size(); ++b) {
                    formula.add(this.f.clause(u.get(a).negate(), v.get(b).negate(), w.get(a + b + 1)));
                }
            }
            for (i = 0; i < v.size(); ++i) {
                formula.add(this.f.clause(v.get(i).negate(), w.get(i)));
            }
            for (i = 0; i < u.size(); ++i) {
                formula.add(this.f.clause(u.get(i).negate(), w.get(i)));
            }
        }
    }
}

