/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.pseudobooleans;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.pseudobooleans.PBEncoding;

public final class PBAdderNetworks
implements PBEncoding {
    private final FormulaFactory f;
    private List<Formula> formula;

    public PBAdderNetworks(FormulaFactory f) {
        this.f = f;
    }

    private static int ldInt(int x) {
        int ldretutn = 0;
        for (int i = 0; i < 31; ++i) {
            if ((x & 1 << i) <= 0) continue;
            ldretutn = i + 1;
        }
        return ldretutn;
    }

    @Override
    public List<Formula> encode(LNGVector<Literal> lits, LNGIntVector coeffs, int rhs, List<Formula> formula) {
        this.formula = formula;
        LNGVector<Literal> result = new LNGVector<Literal>();
        LNGVector<LinkedList<Literal>> buckets = new LNGVector<LinkedList<Literal>>();
        int nb = PBAdderNetworks.ldInt(rhs);
        for (int iBit = 0; iBit < nb; ++iBit) {
            buckets.push(new LinkedList());
            result.push(null);
            for (int iVar = 0; iVar < lits.size(); ++iVar) {
                if ((1 << iBit & coeffs.get(iVar)) == 0) continue;
                buckets.back().push(lits.get(iVar));
            }
        }
        this.adderTree(buckets, result);
        LNGBooleanVector kBits = this.numToBits(buckets.size(), rhs);
        this.lessThanOrEqual(result, kBits, formula);
        return formula;
    }

    private void adderTree(LNGVector<LinkedList<Literal>> buckets, LNGVector<Literal> result) {
        for (int i = 0; i < buckets.size(); ++i) {
            Literal y;
            Literal x;
            if (buckets.get(i).isEmpty()) continue;
            if (i == buckets.size() - 1 && buckets.get(i).size() >= 2) {
                buckets.push(new LinkedList());
                result.push(null);
            }
            while (buckets.get(i).size() >= 3) {
                x = buckets.get(i).removeFirst();
                y = buckets.get(i).removeFirst();
                Literal z = buckets.get(i).removeFirst();
                Literal xs = this.faSum(x, y, z);
                Literal xc = this.faCarry(x, y, z);
                buckets.get(i).add(xs);
                buckets.get(i + 1).add(xc);
                this.faExtra(xc, xs, x, y, z);
            }
            if (buckets.get(i).size() == 2) {
                x = buckets.get(i).removeFirst();
                y = buckets.get(i).removeFirst();
                buckets.get(i).add(this.haSum(x, y));
                buckets.get(i + 1).add(this.haCarry(x, y));
            }
            result.set(i, buckets.get(i).removeFirst());
        }
    }

    private LNGBooleanVector numToBits(int n, int num) {
        int number = num;
        LNGBooleanVector bits = new LNGBooleanVector();
        for (int i = n - 1; i >= 0; --i) {
            int tmp = 1 << i;
            if (number < tmp) {
                bits.push(false);
                continue;
            }
            bits.push(true);
            number -= tmp;
        }
        bits.reverseInplace();
        return bits;
    }

    private void lessThanOrEqual(LNGVector<Literal> xs, LNGBooleanVector ys, List<Formula> formula) {
        assert (xs.size() == ys.size());
        ArrayList<Literal> clause = new ArrayList<Literal>();
        for (int i = 0; i < xs.size(); ++i) {
            if (ys.get(i) || xs.get(i) == null) continue;
            clause.clear();
            boolean skip = false;
            for (int j = i + 1; j < xs.size(); ++j) {
                if (ys.get(j)) {
                    if (xs.get(j) == null) {
                        skip = true;
                        break;
                    }
                    clause.add(xs.get(j).negate());
                    continue;
                }
                if (xs.get(j) == null) continue;
                clause.add(xs.get(j));
            }
            if (skip) continue;
            clause.add(xs.get(i).negate());
            formula.add(this.f.clause(clause));
        }
    }

    private void faExtra(Literal xc, Literal xs, Literal a, Literal b, Literal c) {
        this.formula.add(this.f.clause(xc.negate(), xs.negate(), a));
        this.formula.add(this.f.clause(xc.negate(), xs.negate(), b));
        this.formula.add(this.f.clause(xc.negate(), xs.negate(), c));
        this.formula.add(this.f.clause(xc, xs, a.negate()));
        this.formula.add(this.f.clause(xc, xs, b.negate()));
        this.formula.add(this.f.clause(xc, xs, c.negate()));
    }

    private Literal faCarry(Literal a, Literal b, Literal c) {
        Variable x = this.f.newPBVariable();
        this.formula.add(this.f.clause(b, c, x.negate()));
        this.formula.add(this.f.clause(a, c, x.negate()));
        this.formula.add(this.f.clause(a, b, x.negate()));
        this.formula.add(this.f.clause(b.negate(), c.negate(), x));
        this.formula.add(this.f.clause(a.negate(), c.negate(), x));
        this.formula.add(this.f.clause(a.negate(), b.negate(), x));
        return x;
    }

    private Literal faSum(Literal a, Literal b, Literal c) {
        Variable x = this.f.newPBVariable();
        this.formula.add(this.f.clause(a, b, c, x.negate()));
        this.formula.add(this.f.clause(a, b.negate(), c.negate(), x.negate()));
        this.formula.add(this.f.clause(a.negate(), b, c.negate(), x.negate()));
        this.formula.add(this.f.clause(a.negate(), b.negate(), c, x.negate()));
        this.formula.add(this.f.clause(a.negate(), b.negate(), c.negate(), x));
        this.formula.add(this.f.clause(a.negate(), b, c, x));
        this.formula.add(this.f.clause(a, b.negate(), c, x));
        this.formula.add(this.f.clause(a, b, c.negate(), x));
        return x;
    }

    private Literal haCarry(Literal a, Literal b) {
        Variable x = this.f.newPBVariable();
        this.formula.add(this.f.clause(a, x.negate()));
        this.formula.add(this.f.clause(b, x.negate()));
        this.formula.add(this.f.clause(a.negate(), b.negate(), x));
        return x;
    }

    private Literal haSum(Literal a, Literal b) {
        Variable x = this.f.newPBVariable();
        this.formula.add(this.f.clause(a.negate(), b.negate(), x.negate()));
        this.formula.add(this.f.clause(a, b, x.negate()));
        this.formula.add(this.f.clause(a.negate(), b, x));
        this.formula.add(this.f.clause(a, b.negate(), x));
        return x;
    }
}

