/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.primecomputation;

import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import org.logicng.formulas.Literal;

public final class PrimeResult {
    private final List<SortedSet<Literal>> primeImplicants;
    private final List<SortedSet<Literal>> primeImplicates;
    private final CoverageType coverageType;

    public PrimeResult(List<SortedSet<Literal>> primeImplicants, List<SortedSet<Literal>> primeImplicates, CoverageType coverageType) {
        this.primeImplicants = primeImplicants;
        this.primeImplicates = primeImplicates;
        this.coverageType = coverageType;
    }

    public List<SortedSet<Literal>> getPrimeImplicants() {
        return this.primeImplicants;
    }

    public List<SortedSet<Literal>> getPrimeImplicates() {
        return this.primeImplicates;
    }

    public CoverageType getCoverageType() {
        return this.coverageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimeResult that = (PrimeResult)o;
        return Objects.equals(this.primeImplicants, that.primeImplicants) && Objects.equals(this.primeImplicates, that.primeImplicates) && this.coverageType == that.coverageType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.primeImplicants, this.primeImplicates, this.coverageType});
    }

    public String toString() {
        return "PrimeResult{primeImplicants=" + this.primeImplicants + ", primeImplicates=" + this.primeImplicates + ", coverageInfo=" + (Object)((Object)this.coverageType) + '}';
    }

    public static enum CoverageType {
        IMPLICANTS_COMPLETE,
        IMPLICATES_COMPLETE;

    }
}

