/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.primecomputation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.primecomputation.NaivePrimeReduction;
import org.logicng.primecomputation.PrimeResult;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.functions.OptimizationFunction;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.transformations.LiteralSubstitution;
import org.logicng.util.FormulaHelper;
import org.logicng.util.Pair;

public final class PrimeCompiler {
    private static final String POS = "_POS";
    private static final String NEG = "_NEG";
    private static final PrimeCompiler INSTANCE_MIN = new PrimeCompiler(false);
    private static final PrimeCompiler INSTANCE_MAX = new PrimeCompiler(true);
    private final boolean computeWithMaximization;

    private PrimeCompiler(boolean computeWithMaximization) {
        this.computeWithMaximization = computeWithMaximization;
    }

    public static PrimeCompiler getWithMinimization() {
        return INSTANCE_MIN;
    }

    public static PrimeCompiler getWithMaximization() {
        return INSTANCE_MAX;
    }

    public PrimeResult compute(Formula formula, PrimeResult.CoverageType type) {
        boolean completeImplicants = type == PrimeResult.CoverageType.IMPLICANTS_COMPLETE;
        Formula formulaForComputation = completeImplicants ? formula : formula.negate();
        Pair<List<SortedSet<Literal>>, List<SortedSet<Literal>>> result = this.computeGeneric(formulaForComputation);
        return new PrimeResult(completeImplicants ? result.first() : this.negateAll((Collection<SortedSet<Literal>>)result.second()), completeImplicants ? result.second() : this.negateAll((Collection<SortedSet<Literal>>)result.first()), type);
    }

    private Pair<List<SortedSet<Literal>>, List<SortedSet<Literal>>> computeGeneric(Formula formula) {
        FormulaFactory f = formula.factory();
        SubstitutionResult sub = this.createSubstitution(formula);
        MiniSat hSolver = MiniSat.miniSat(f, MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        hSolver.add(sub.constraintFormula);
        MiniSat fSolver = MiniSat.miniSat(f, MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        fSolver.add(formula.negate());
        NaivePrimeReduction primeReduction = new NaivePrimeReduction(formula);
        ArrayList<SortedSet<Literal>> primeImplicants = new ArrayList<SortedSet<Literal>>();
        ArrayList<SortedSet<Literal>> primeImplicates = new ArrayList<SortedSet<Literal>>();
        Assignment hModel;
        while ((hModel = ((SATSolver)hSolver).execute(this.computeWithMaximization ? OptimizationFunction.maximize(sub.newVar2oldLit.keySet()) : OptimizationFunction.minimize(sub.newVar2oldLit.keySet()))) != null) {
            Assignment fModel = this.transformModel(hModel, sub.newVar2oldLit);
            Tristate fSat = fSolver.sat(fModel.literals());
            if (fSat == Tristate.FALSE) {
                SortedSet<Literal> primeImplicant = this.computeWithMaximization ? primeReduction.reduceImplicant(fModel.literals()) : fModel.literals();
                primeImplicants.add(primeImplicant);
                ArrayList blockingClause = new ArrayList();
                for (Literal lit : primeImplicant) {
                    blockingClause.add(((Literal)lit.transform(sub.substitution)).negate());
                }
                hSolver.add(f.or(blockingClause));
                continue;
            }
            TreeSet<Literal> implicate = new TreeSet<Literal>();
            for (Literal lit : (this.computeWithMaximization ? fModel : ((SATSolver)fSolver).model(formula.variables())).literals()) {
                implicate.add(lit.negate());
            }
            SortedSet<Literal> primeImplicate = primeReduction.reduceImplicate(implicate);
            primeImplicates.add(primeImplicate);
            hSolver.add(f.or(primeImplicate).transform(sub.substitution));
        }
        return new Pair<List<SortedSet<Literal>>, List<SortedSet<Literal>>>(primeImplicants, primeImplicates);
    }

    private SubstitutionResult createSubstitution(Formula formula) {
        HashMap<Variable, Literal> newVar2oldLit = new HashMap<Variable, Literal>();
        LiteralSubstitution substitution = new LiteralSubstitution();
        ArrayList<Formula> constraintOps = new ArrayList<Formula>();
        for (Variable variable : formula.variables()) {
            Variable posVar = formula.factory().variable(variable.name() + POS);
            newVar2oldLit.put(posVar, variable);
            substitution.addSubstitution(variable, posVar);
            Variable negVar = formula.factory().variable(variable.name() + NEG);
            newVar2oldLit.put(negVar, variable.negate());
            substitution.addSubstitution(variable.negate(), negVar);
            constraintOps.add(formula.factory().amo(posVar, negVar));
        }
        return new SubstitutionResult(newVar2oldLit, substitution, formula.factory().and(constraintOps));
    }

    private Assignment transformModel(Assignment model, Map<Variable, Literal> mapping) {
        Assignment mapped = new Assignment();
        for (Variable var : model.positiveVariables()) {
            mapped.addLiteral(mapping.get(var));
        }
        return mapped;
    }

    private List<SortedSet<Literal>> negateAll(Collection<SortedSet<Literal>> literalSets) {
        ArrayList<SortedSet<Literal>> result = new ArrayList<SortedSet<Literal>>();
        for (SortedSet<Literal> literals : literalSets) {
            result.add(FormulaHelper.negateLiterals(literals, TreeSet::new));
        }
        return result;
    }

    private static class SubstitutionResult {
        private final Map<Variable, Literal> newVar2oldLit;
        private final LiteralSubstitution substitution;
        private final Formula constraintFormula;

        private SubstitutionResult(Map<Variable, Literal> newVar2oldLit, LiteralSubstitution substitution, Formula constraintFormula) {
            this.newVar2oldLit = newVar2oldLit;
            this.substitution = substitution;
            this.constraintFormula = constraintFormula;
        }
    }
}

