/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.primecomputation;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.util.FormulaHelper;

public final class NaivePrimeReduction {
    private final SATSolver implicantSolver;
    private final SATSolver implicateSolver;

    public NaivePrimeReduction(Formula formula) {
        FormulaFactory f = formula.factory();
        this.implicantSolver = MiniSat.miniSat(f, MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        this.implicantSolver.add(formula.negate());
        this.implicateSolver = MiniSat.miniSat(f, MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        this.implicateSolver.add(formula);
    }

    public SortedSet<Literal> reduceImplicant(SortedSet<Literal> implicant) {
        TreeSet<Literal> primeImplicant = new TreeSet<Literal>(implicant);
        for (Literal lit : implicant) {
            primeImplicant.remove(lit);
            if (this.implicantSolver.sat(primeImplicant) != Tristate.TRUE) continue;
            primeImplicant.add(lit);
        }
        return primeImplicant;
    }

    public SortedSet<Literal> reduceImplicate(SortedSet<Literal> implicate) {
        TreeSet<Literal> primeImplicate = new TreeSet<Literal>(implicate);
        for (Literal lit : implicate) {
            primeImplicate.remove(lit);
            List assumptions = FormulaHelper.negateLiterals(primeImplicate, ArrayList::new);
            if (this.implicateSolver.sat(assumptions) != Tristate.TRUE) continue;
            primeImplicate.add(lit);
        }
        return primeImplicate;
    }
}

