/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates.satisfiability;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;
import org.logicng.predicates.satisfiability.SATPredicate;

public final class TautologyPredicate
implements FormulaPredicate {
    private final SATPredicate satPredicate;

    public TautologyPredicate(FormulaFactory f) {
        this.satPredicate = new SATPredicate(f);
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        boolean result;
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_TAUTOLOGY);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        Formula negation = formula.negate();
        boolean bl = result = !negation.holds(this.satPredicate);
        if (cache) {
            formula.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_TAUTOLOGY, result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

