/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates.satisfiability;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;

public final class SATPredicate
implements FormulaPredicate {
    private final SATSolver solver;

    public SATPredicate(FormulaFactory f) {
        this.solver = MiniSat.miniSat(f);
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        boolean result;
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_SAT);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        if (formula.type() == FType.FALSE) {
            result = false;
        } else {
            this.solver.add(formula);
            result = this.solver.sat() == Tristate.TRUE;
            this.solver.reset();
        }
        if (cache) {
            formula.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_SAT, result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

