/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;

public final class NNFPredicate
implements FormulaPredicate {
    private static final NNFPredicate INSTANCE = new NNFPredicate();

    private NNFPredicate() {
    }

    public static NNFPredicate get() {
        return INSTANCE;
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        boolean result;
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_NNF);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        block0 : switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                result = true;
                break;
            }
            case AND: 
            case OR: {
                result = true;
                for (Formula op : formula) {
                    if (this.test(op, cache)) continue;
                    result = false;
                    break block0;
                }
                break;
            }
            case NOT: 
            case IMPL: 
            case EQUIV: 
            case PBC: {
                result = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot compute NNF predicate on " + (Object)((Object)formula.type()));
            }
        }
        if (cache) {
            formula.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_NNF, result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

