/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.And;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.formulas.Or;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;

public final class EvaluatesToConstantPredicate
implements FormulaPredicate {
    private final boolean evaluatesToTrue;
    private final Map<Variable, Boolean> mapping;

    public EvaluatesToConstantPredicate(boolean evaluatesToTrue, Map<Variable, Boolean> mapping) {
        this.evaluatesToTrue = evaluatesToTrue;
        this.mapping = mapping;
    }

    public Map<Variable, Boolean> getMapping() {
        return Collections.unmodifiableMap(this.mapping);
    }

    @Override
    public boolean test(Formula formula, boolean caching) {
        return this.innerTest(formula, true).type() == EvaluatesToConstantPredicate.getConstantType(this.evaluatesToTrue);
    }

    private Formula innerTest(Formula formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case TRUE: 
            case FALSE: {
                return formula;
            }
            case LITERAL: {
                Literal lit = (Literal)formula;
                Boolean found = this.mapping.get(lit.variable());
                return found == null ? lit : f.constant(lit.phase() == found.booleanValue());
            }
            case NOT: {
                return this.handleNot((Not)formula, topLevel);
            }
            case IMPL: {
                return this.handleImplication((Implication)formula, topLevel);
            }
            case EQUIV: {
                return this.handleEquivalence((Equivalence)formula, topLevel);
            }
            case OR: {
                return this.handleOr((Or)formula, topLevel);
            }
            case AND: {
                return this.handleAnd((And)formula, topLevel);
            }
            case PBC: {
                return this.handlePBC((PBConstraint)formula);
            }
        }
        throw new IllegalArgumentException("Unknown formula type " + (Object)((Object)formula.type()));
    }

    private Formula handleNot(Not formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        Formula opResult = this.innerTest(formula.operand(), false);
        if (topLevel && !opResult.isConstantFormula()) {
            return f.constant(!this.evaluatesToTrue);
        }
        return opResult.isConstantFormula() ? f.constant(EvaluatesToConstantPredicate.isFalsum(opResult)) : f.not(opResult);
    }

    private Formula handleImplication(Implication formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        Formula left = formula.left();
        Formula right = formula.right();
        Formula leftResult = this.innerTest(left, false);
        if (leftResult.isConstantFormula()) {
            if (this.evaluatesToTrue) {
                return EvaluatesToConstantPredicate.isFalsum(leftResult) ? f.verum() : this.innerTest(right, topLevel);
            }
            return EvaluatesToConstantPredicate.isVerum(leftResult) ? this.innerTest(right, topLevel) : f.verum();
        }
        if (!this.evaluatesToTrue && topLevel) {
            return f.verum();
        }
        Formula rightResult = this.innerTest(right, false);
        if (rightResult.isConstantFormula()) {
            return EvaluatesToConstantPredicate.isVerum(rightResult) ? f.verum() : f.not(leftResult);
        }
        return f.implication(leftResult, rightResult);
    }

    private Formula handleEquivalence(Equivalence formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        Formula left = formula.left();
        Formula right = formula.right();
        Formula leftResult = this.innerTest(left, false);
        if (leftResult.isConstantFormula()) {
            return EvaluatesToConstantPredicate.isVerum(leftResult) ? this.innerTest(right, topLevel) : this.innerTest(f.not(right), topLevel);
        }
        Formula rightResult = this.innerTest(right, false);
        if (rightResult.isConstantFormula()) {
            if (topLevel) {
                return f.constant(!this.evaluatesToTrue);
            }
            return EvaluatesToConstantPredicate.isVerum(rightResult) ? leftResult : f.not(leftResult);
        }
        return f.equivalence(leftResult, rightResult);
    }

    private Formula handleOr(Or formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        ArrayList<Formula> nops = new ArrayList<Formula>();
        for (Formula op : formula) {
            Formula opResult = this.innerTest(op, !this.evaluatesToTrue && topLevel);
            if (EvaluatesToConstantPredicate.isVerum(opResult)) {
                return f.verum();
            }
            if (opResult.isConstantFormula()) continue;
            if (!this.evaluatesToTrue && topLevel) {
                return f.verum();
            }
            nops.add(opResult);
        }
        return f.or(nops);
    }

    private Formula handleAnd(And formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        ArrayList<Formula> nops = new ArrayList<Formula>();
        for (Formula op : formula) {
            Formula opResult = this.innerTest(op, this.evaluatesToTrue && topLevel);
            if (EvaluatesToConstantPredicate.isFalsum(opResult)) {
                return f.falsum();
            }
            if (opResult.isConstantFormula()) continue;
            if (this.evaluatesToTrue && topLevel) {
                return f.falsum();
            }
            nops.add(opResult);
        }
        return f.and(nops);
    }

    private Formula handlePBC(PBConstraint formula) {
        FormulaFactory f = formula.factory();
        Assignment assignment = new Assignment();
        for (Map.Entry<Variable, Boolean> entry : this.mapping.entrySet()) {
            assignment.addLiteral(f.literal(entry.getKey().name(), entry.getValue()));
        }
        return formula.restrict(assignment);
    }

    private static FType getConstantType(boolean constant) {
        return constant ? FType.TRUE : FType.FALSE;
    }

    private static boolean isFalsum(Formula formula) {
        return formula.type() == FType.FALSE;
    }

    private static boolean isVerum(Formula formula) {
        return formula.type() == FType.TRUE;
    }
}

