/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;

public final class DNFPredicate
implements FormulaPredicate {
    private static final DNFPredicate INSTANCE = new DNFPredicate();

    private DNFPredicate() {
    }

    public static DNFPredicate get() {
        return INSTANCE;
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        boolean result;
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_DNF);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return true;
            }
            case NOT: 
            case IMPL: 
            case EQUIV: 
            case PBC: {
                return false;
            }
            case OR: {
                result = true;
                for (Formula op : formula) {
                    if (this.isDNFClause(op)) continue;
                    result = false;
                }
                break;
            }
            case AND: {
                result = this.isDNFClause(formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot compute DNF predicate on " + (Object)((Object)formula.type()));
            }
        }
        if (cache) {
            formula.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_DNF, result);
        }
        return result;
    }

    private boolean isDNFClause(Formula formula) {
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return true;
            }
            case NOT: 
            case IMPL: 
            case EQUIV: 
            case PBC: 
            case OR: {
                return false;
            }
            case AND: {
                for (Formula op : formula) {
                    if (op.type() == FType.LITERAL) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Cannot compute DNF clause predicate on " + (Object)((Object)formula.type()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

