/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.Not;

public final class ContainsPBCPredicate
implements FormulaPredicate {
    private static final ContainsPBCPredicate INSTANCE = new ContainsPBCPredicate();

    private ContainsPBCPredicate() {
    }

    public static ContainsPBCPredicate get() {
        return INSTANCE;
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return false;
            }
            case AND: 
            case OR: {
                for (Formula op : formula) {
                    if (!this.test(op, cache)) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return this.test(((Not)formula).operand(), cache);
            }
            case IMPL: 
            case EQUIV: {
                BinaryOperator binary = (BinaryOperator)formula;
                return this.test(binary.left(), cache) || this.test(binary.right(), cache);
            }
            case PBC: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown formula type " + (Object)((Object)formula.type()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

