/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.cache.PredicateCacheEntry;

public final class CNFPredicate
implements FormulaPredicate {
    private static final CNFPredicate INSTANCE = new CNFPredicate();

    private CNFPredicate() {
    }

    public static CNFPredicate get() {
        return INSTANCE;
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_CNF);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return true;
            }
            case NOT: 
            case IMPL: 
            case EQUIV: 
            case PBC: {
                return false;
            }
            case OR: 
            case AND: {
                throw new IllegalStateException("Formula of type AND/OR has no cached CNF predicate, but should have.");
            }
        }
        throw new IllegalArgumentException("Cannot compute CNF predicate on " + (Object)((Object)formula.type()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

