/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.predicates;

import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaPredicate;
import org.logicng.formulas.Not;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;

public final class AIGPredicate
implements FormulaPredicate {
    private static final AIGPredicate INSTANCE = new AIGPredicate();

    private AIGPredicate() {
    }

    public static AIGPredicate get() {
        return INSTANCE;
    }

    @Override
    public boolean test(Formula formula, boolean cache) {
        boolean result;
        Tristate cached = formula.predicateCacheEntry(PredicateCacheEntry.IS_AIG);
        if (cached != Tristate.UNDEF) {
            return cached == Tristate.TRUE;
        }
        block0 : switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                result = true;
                break;
            }
            case IMPL: 
            case EQUIV: 
            case OR: 
            case PBC: {
                result = false;
                break;
            }
            case NOT: {
                result = this.test(((Not)formula).operand(), cache);
                break;
            }
            case AND: {
                result = true;
                for (Formula op : formula) {
                    if (this.test(op, cache)) continue;
                    result = false;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot compute AIG predicate on " + (Object)((Object)formula.type()));
            }
        }
        if (cache) {
            formula.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

