/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.np;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MaxSATSolver;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.util.CollectionHelper;

public final class SetCover {
    private SetCover() {
    }

    public static <T> List<Set<T>> compute(Collection<Set<T>> sets) {
        if (sets.isEmpty()) {
            return Collections.emptyList();
        }
        FormulaFactory f = new FormulaFactory();
        HashMap<Variable, Set<T>> setMap = new HashMap<Variable, Set<T>>();
        HashMap<Object, Set> elementOccurrences = new HashMap<Object, Set>();
        for (Set<T> set : sets) {
            Variable setVar = f.variable("@SET_SEL_" + setMap.size());
            setMap.put(setVar, set);
            for (T element : set) {
                elementOccurrences.computeIfAbsent(element, i -> new LinkedHashSet()).add(setVar);
            }
        }
        MaxSATSolver solver = MaxSATSolver.msu3();
        for (Set occurrences : elementOccurrences.values()) {
            solver.addHardFormula(f.or(occurrences));
        }
        for (Variable setVar : setMap.keySet()) {
            solver.addSoftFormula(setVar.negate(), 1);
        }
        if (solver.solve() != MaxSAT.MaxSATResult.OPTIMUM) {
            throw new IllegalStateException("Internal optimization problem was not feasible.");
        }
        ArrayList arrayList = CollectionHelper.intersection(solver.model().positiveVariables(), setMap.keySet(), ArrayList::new);
        ArrayList<Set<T>> result = new ArrayList<Set<T>>();
        for (Variable setVar : arrayList) {
            result.add((Set<T>)setMap.get(setVar));
        }
        return result;
    }
}

