/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf.functions;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.FunctionCacheEntry;
import org.logicng.knowledgecompilation.dnnf.functions.DnnfFunction;

public final class DnnfModelCountFunction
implements DnnfFunction<BigInteger> {
    private static final DnnfModelCountFunction INSTANCE = new DnnfModelCountFunction();

    private DnnfModelCountFunction() {
    }

    public static DnnfModelCountFunction get() {
        return INSTANCE;
    }

    @Override
    public BigInteger apply(SortedSet<Variable> originalVariables, Formula formula) {
        Object cached = formula.functionCacheEntry(FunctionCacheEntry.DNNF_MODELCOUNT);
        BigInteger result = cached != null ? (BigInteger)cached : this.count(formula, new HashMap<Formula, BigInteger>());
        formula.setFunctionCacheEntry(FunctionCacheEntry.DNNF_MODELCOUNT, result);
        TreeSet<Variable> dontCareVariables = new TreeSet<Variable>();
        SortedSet<Variable> dnnfVariables = formula.variables();
        for (Variable originalVariable : originalVariables) {
            if (dnnfVariables.contains(originalVariable)) continue;
            dontCareVariables.add(originalVariable);
        }
        BigInteger factor = BigInteger.valueOf(2L).pow(dontCareVariables.size());
        return result.multiply(factor);
    }

    private BigInteger count(Formula dnnf, Map<Formula, BigInteger> internalCache) {
        BigInteger c = internalCache.get(dnnf);
        if (c == null) {
            switch (dnnf.type()) {
                case LITERAL: 
                case TRUE: {
                    c = BigInteger.ONE;
                    break;
                }
                case AND: {
                    c = BigInteger.ONE;
                    for (Formula op : dnnf) {
                        c = c.multiply(this.count(op, internalCache));
                    }
                    break;
                }
                case OR: {
                    int allVariables = dnnf.variables().size();
                    c = BigInteger.ZERO;
                    for (Formula op : dnnf) {
                        BigInteger opCount = this.count(op, internalCache);
                        BigInteger factor = BigInteger.valueOf(2L).pow(allVariables - op.variables().size());
                        c = c.add(opCount.multiply(factor));
                    }
                    break;
                }
                case FALSE: {
                    c = BigInteger.ZERO;
                }
            }
            internalCache.put(dnnf, c);
        }
        return c;
    }
}

