/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf.datastructures.dtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import org.logicng.collections.LNGIntVector;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTree;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.EliminatingOrderDTreeGenerator;

public class MinFillDTreeGenerator
extends EliminatingOrderDTreeGenerator {
    @Override
    public DTree generate(Formula cnf) {
        Graph graph = new Graph(cnf);
        List<Variable> ordering = graph.getMinFillOrdering();
        return this.generateWithEliminatingOrder(cnf, ordering);
    }

    public static class Graph {
        protected final int numberOfVertices;
        protected final int numberOfEdges;
        protected final boolean[][] adjMatrix;
        protected final List<Variable> vertices;
        protected final List<LNGIntVector> edgeList;

        /*
         * WARNING - void declaration
         */
        public Graph(Formula cnf) {
            this.numberOfVertices = cnf.variables().size();
            this.vertices = new ArrayList<Variable>(this.numberOfVertices);
            HashMap<Variable, Integer> varToIndex = new HashMap<Variable, Integer>();
            int index = 0;
            for (Variable variable : cnf.variables()) {
                this.vertices.add(variable);
                varToIndex.put(variable, index++);
            }
            this.adjMatrix = new boolean[this.numberOfVertices][this.numberOfVertices];
            this.edgeList = new ArrayList<LNGIntVector>(this.numberOfVertices);
            for (int i = 0; i < this.numberOfVertices; ++i) {
                this.edgeList.add(new LNGIntVector());
            }
            int numberOfEdges = 0;
            for (Formula clause : cnf) {
                SortedSet<Variable> variables = clause.variables();
                int[] varNums = new int[variables.size()];
                index = 0;
                for (Literal literal : variables) {
                    varNums[index++] = (Integer)varToIndex.get(literal);
                }
                for (int i = 0; i < varNums.length; ++i) {
                    void var10_14;
                    int n = i + 1;
                    while (var10_14 < varNums.length) {
                        this.edgeList.get(varNums[i]).push(varNums[var10_14]);
                        this.edgeList.get(varNums[var10_14]).push(varNums[i]);
                        this.adjMatrix[varNums[i]][varNums[var10_14]] = true;
                        this.adjMatrix[varNums[var10_14]][varNums[i]] = true;
                        ++numberOfEdges;
                        ++var10_14;
                    }
                }
            }
            this.numberOfEdges = numberOfEdges;
        }

        protected List<LNGIntVector> getCopyOfEdgeList() {
            ArrayList<LNGIntVector> result = new ArrayList<LNGIntVector>();
            for (LNGIntVector edge : this.edgeList) {
                result.add(new LNGIntVector(edge));
            }
            return result;
        }

        protected boolean[][] getCopyOfAdjMatrix() {
            boolean[][] result = new boolean[this.numberOfVertices][this.numberOfVertices];
            for (int i = 0; i < this.numberOfVertices; ++i) {
                result[i] = Arrays.copyOf(this.adjMatrix[i], this.numberOfVertices);
            }
            return result;
        }

        protected List<Variable> getMinFillOrdering() {
            boolean[][] fillAdjMatrix = this.getCopyOfAdjMatrix();
            List<LNGIntVector> fillEdgeList = this.getCopyOfEdgeList();
            Variable[] ordering = new Variable[this.numberOfVertices];
            boolean[] processed = new boolean[this.numberOfVertices];
            int treewidth = 0;
            for (int iteration = 0; iteration < this.numberOfVertices; ++iteration) {
                LNGIntVector possiblyBestVertices = new LNGIntVector();
                int minEdges = Integer.MAX_VALUE;
                for (int currentVertex = 0; currentVertex < this.numberOfVertices; ++currentVertex) {
                    if (processed[currentVertex]) continue;
                    int edgesAdded = 0;
                    LNGIntVector neighborList = fillEdgeList.get(currentVertex);
                    for (int i = 0; i < neighborList.size(); ++i) {
                        int firstNeighbor = neighborList.get(i);
                        if (processed[firstNeighbor]) continue;
                        for (int j = i + 1; j < neighborList.size(); ++j) {
                            int secondNeighbor = neighborList.get(j);
                            if (processed[secondNeighbor] || fillAdjMatrix[firstNeighbor][secondNeighbor]) continue;
                            ++edgesAdded;
                        }
                    }
                    if (edgesAdded < minEdges) {
                        minEdges = edgesAdded;
                        possiblyBestVertices.clear();
                        possiblyBestVertices.push(currentVertex);
                        continue;
                    }
                    if (edgesAdded != minEdges) continue;
                    possiblyBestVertices.push(currentVertex);
                }
                int bestVertex = possiblyBestVertices.get(0);
                LNGIntVector neighborList = fillEdgeList.get(bestVertex);
                for (int i = 0; i < neighborList.size(); ++i) {
                    int firstNeighbor = neighborList.get(i);
                    if (processed[firstNeighbor]) continue;
                    for (int j = i + 1; j < neighborList.size(); ++j) {
                        int secondNeighbor = neighborList.get(j);
                        if (processed[secondNeighbor] || fillAdjMatrix[firstNeighbor][secondNeighbor]) continue;
                        fillAdjMatrix[firstNeighbor][secondNeighbor] = true;
                        fillAdjMatrix[secondNeighbor][firstNeighbor] = true;
                        fillEdgeList.get(firstNeighbor).push(secondNeighbor);
                        fillEdgeList.get(secondNeighbor).push(firstNeighbor);
                    }
                }
                int currentNumberOfEdges = 0;
                for (int k = 0; k < this.numberOfVertices; ++k) {
                    if (!fillAdjMatrix[bestVertex][k] || processed[k]) continue;
                    ++currentNumberOfEdges;
                }
                if (treewidth < currentNumberOfEdges) {
                    treewidth = currentNumberOfEdges;
                }
                processed[bestVertex] = true;
                ordering[iteration] = this.vertices.get(bestVertex);
            }
            return Arrays.asList(ordering);
        }
    }
}

