/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf.datastructures.dtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTree;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeGenerator;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeLeaf;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeNode;
import org.logicng.predicates.CNFPredicate;

public abstract class EliminatingOrderDTreeGenerator
implements DTreeGenerator {
    public final DTree generateWithEliminatingOrder(Formula cnf, List<Variable> ordering) {
        assert (cnf.variables().size() == ordering.size());
        if (!cnf.holds(CNFPredicate.get()) || cnf.isAtomicFormula()) {
            throw new IllegalArgumentException("Cannot generate DTree from a non-cnf formula or atomic formula");
        }
        if (cnf.type() != FType.AND) {
            return new DTreeLeaf(0, cnf);
        }
        ArrayList<DTree> sigma = new ArrayList<DTree>();
        int id = 0;
        for (Formula clause : cnf) {
            sigma.add(new DTreeLeaf(id++, clause));
        }
        for (Variable variable : ordering) {
            ArrayList<DTree> gamma = new ArrayList<DTree>();
            Iterator sigmaIterator = sigma.iterator();
            while (sigmaIterator.hasNext()) {
                DTree tree = (DTree)sigmaIterator.next();
                if (!tree.staticVariableSet().contains(variable)) continue;
                gamma.add(tree);
                sigmaIterator.remove();
            }
            if (gamma.isEmpty()) continue;
            sigma.add(this.compose(gamma));
        }
        return this.compose(sigma);
    }

    protected DTree compose(List<DTree> trees) {
        assert (!trees.isEmpty());
        if (trees.size() == 1) {
            return trees.get(0);
        }
        DTree left = this.compose(trees.subList(0, trees.size() / 2));
        DTree right = this.compose(trees.subList(trees.size() / 2, trees.size()));
        return new DTreeNode(left, right);
    }
}

