/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf.datastructures.dtree;

import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.dnnf.DnnfSatSolver;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTree;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeLeaf;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class DTreeNode
extends DTree {
    protected final DTree left;
    protected final DTree right;
    protected final int size;
    protected DnnfSatSolver solver;
    protected final SortedSet<Variable> staticVariableSet;
    protected final BitSet staticSeparatorBitSet;
    protected final int[] staticClauseIds;
    protected final int depth;
    protected int widestSeparator;
    protected final DTreeLeaf[] leafs;
    protected final DTreeLeaf[] leftLeafs;
    protected final DTreeLeaf[] rightLeafs;
    protected int[] clauseContents;
    protected int[] leftClauseContents;
    protected int[] rightClauseContents;
    protected BitSet localLeftVarSet;
    protected BitSet localRightVarSet;

    public DTreeNode(DTree left, DTree right) {
        this.left = left;
        this.right = right;
        this.size = left.size() + right.size();
        List<DTreeLeaf> ll = left.leafs();
        this.excludeUnitLeafs(ll);
        this.leftLeafs = ll.toArray(new DTreeLeaf[0]);
        List<DTreeLeaf> rl = right.leafs();
        this.excludeUnitLeafs(rl);
        this.rightLeafs = rl.toArray(new DTreeLeaf[0]);
        this.leafs = new DTreeLeaf[this.leftLeafs.length + this.rightLeafs.length];
        System.arraycopy(this.leftLeafs, 0, this.leafs, 0, this.leftLeafs.length);
        System.arraycopy(this.rightLeafs, 0, this.leafs, this.leftLeafs.length, this.rightLeafs.length);
        this.staticVariableSet = new TreeSet<Variable>(left.staticVariableSet());
        this.staticVariableSet.addAll(right.staticVariableSet());
        this.staticSeparatorBitSet = new BitSet();
        int[] leftClauseIds = left.staticClauseIds();
        int[] rightClauseIds = right.staticClauseIds();
        this.staticClauseIds = new int[leftClauseIds.length + rightClauseIds.length];
        System.arraycopy(leftClauseIds, 0, this.staticClauseIds, 0, leftClauseIds.length);
        System.arraycopy(rightClauseIds, 0, this.staticClauseIds, leftClauseIds.length, rightClauseIds.length);
        this.depth = 1 + Math.max(left.depth(), right.depth());
    }

    public DTree left() {
        return this.left;
    }

    public DTree right() {
        return this.right;
    }

    @Override
    public void initialize(DnnfSatSolver solver) {
        this.solver = solver;
        this.left.initialize(solver);
        this.right.initialize(solver);
        this.staticVarSet = this.left.staticVarSet();
        this.staticVarSet.or(this.right.staticVarSet());
        this.staticVariables = DTreeNode.toArray(this.staticVarSet);
        for (int i : this.staticSeparator = DTreeNode.sortedIntersect(this.left.staticVarSetArray(), this.right.staticVarSetArray())) {
            this.staticSeparatorBitSet.set(i);
        }
        this.widestSeparator = Math.max(this.staticSeparator.length, Math.max(this.left.widestSeparator(), this.right.widestSeparator()));
        this.localLeftVarSet = new BitSet(this.staticVariables[this.staticVariables.length - 1]);
        this.localRightVarSet = new BitSet(this.staticVariables[this.staticVariables.length - 1]);
        LNGIntVector lClauseContents = new LNGIntVector();
        for (DTreeLeaf leaf : this.leftLeafs) {
            for (int i : leaf.literals()) {
                lClauseContents.push(i);
            }
            lClauseContents.push(-leaf.getId() - 1);
        }
        this.leftClauseContents = lClauseContents.toArray();
        LNGIntVector rClauseContents = new LNGIntVector();
        for (DTreeLeaf leaf : this.rightLeafs) {
            for (int i : leaf.literals()) {
                rClauseContents.push(i);
            }
            rClauseContents.push(-leaf.getId() - 1);
        }
        this.rightClauseContents = rClauseContents.toArray();
        this.clauseContents = new int[this.leftClauseContents.length + this.rightClauseContents.length];
        System.arraycopy(this.leftClauseContents, 0, this.clauseContents, 0, this.leftClauseContents.length);
        System.arraycopy(this.rightClauseContents, 0, this.clauseContents, this.leftClauseContents.length, this.rightClauseContents.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SortedSet<Variable> staticVariableSet() {
        return this.staticVariableSet;
    }

    @Override
    public BitSet dynamicSeparator() {
        this.localLeftVarSet.clear();
        this.localRightVarSet.clear();
        this.varSet(this.leftClauseContents, this.localLeftVarSet);
        this.varSet(this.rightClauseContents, this.localRightVarSet);
        this.localLeftVarSet.and(this.localRightVarSet);
        return this.localLeftVarSet;
    }

    protected void varSet(int[] clausesContents, BitSet localVarSet) {
        int i = 0;
        while (i < clausesContents.length) {
            int j = i;
            boolean subsumed = false;
            while (clausesContents[j] >= 0) {
                if (!subsumed && this.solver.valueOf(clausesContents[j]) == Tristate.TRUE) {
                    subsumed = true;
                }
                ++j;
            }
            if (!subsumed) {
                for (int n = i; n < j; ++n) {
                    if (this.solver.valueOf(clausesContents[n]) != Tristate.UNDEF) continue;
                    localVarSet.set(MiniSatStyleSolver.var(clausesContents[n]));
                }
            }
            i = j + 1;
        }
    }

    @Override
    public int[] staticClauseIds() {
        return this.staticClauseIds;
    }

    public void cacheKey(BitSet key, int numberOfVariables) {
        int i = 0;
        while (i < this.clauseContents.length) {
            int j = i;
            boolean subsumed = false;
            while (this.clauseContents[j] >= 0) {
                if (!subsumed && this.solver.valueOf(this.clauseContents[j]) == Tristate.TRUE) {
                    subsumed = true;
                }
                ++j;
            }
            if (!subsumed) {
                key.set(-this.clauseContents[j] + 1 + numberOfVariables);
                for (int n = i; n < j; ++n) {
                    if (this.solver.valueOf(this.clauseContents[n]) != Tristate.UNDEF) continue;
                    key.set(MiniSatStyleSolver.var(this.clauseContents[n]));
                }
            }
            i = j + 1;
        }
    }

    @Override
    public void countUnsubsumedOccurrences(int[] occurrences) {
        for (DTreeLeaf leaf : this.leafs) {
            leaf.countUnsubsumedOccurrences(occurrences);
        }
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public int widestSeparator() {
        return this.widestSeparator;
    }

    @Override
    public List<DTreeLeaf> leafs() {
        List<DTreeLeaf> result = this.left.leafs();
        result.addAll(this.right.leafs());
        return result;
    }

    public String toString() {
        return String.format("DTreeNode: [%s, %s]", this.left, this.right);
    }

    protected void excludeUnitLeafs(List<DTreeLeaf> leafs) {
        leafs.removeIf(dTreeLeaf -> dTreeLeaf.clauseSize() == 1);
    }

    static int[] toArray(BitSet bits) {
        int[] result = new int[bits.cardinality()];
        int n = 0;
        int i = bits.nextSetBit(0);
        while (i != -1) {
            result[n++] = i;
            i = bits.nextSetBit(i + 1);
        }
        return result;
    }

    static int[] sortedIntersect(int[] left, int[] right) {
        TreeSet<Integer> l = new TreeSet<Integer>();
        TreeSet<Integer> intersection = new TreeSet<Integer>();
        for (int i : left) {
            l.add(i);
        }
        for (int i : right) {
            if (!l.contains(i)) continue;
            intersection.add(i);
        }
        int[] result = new int[intersection.size()];
        int i = 0;
        for (Integer elem : intersection) {
            result[i++] = elem;
        }
        return result;
    }
}

