/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf.datastructures.dtree;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.dnnf.DnnfSatSolver;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTree;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class DTreeLeaf
extends DTree {
    protected final int id;
    protected final Formula clause;
    protected final int clauseSize;
    protected int[] literals;
    protected int[] dynamicVarSetHelper;
    protected final BitSet separatorBitSet = new BitSet();
    protected DnnfSatSolver solver;
    protected final int[] staticClauseIds;

    public DTreeLeaf(int id, Formula clause) {
        this.id = id;
        this.clause = clause;
        this.staticClauseIds = new int[]{id};
        this.clauseSize = clause.variables().size();
        this.staticSeparator = new int[0];
        assert (this.clauseSize >= 2);
    }

    @Override
    public void initialize(DnnfSatSolver solver) {
        this.solver = solver;
        SortedSet<Literal> lits = this.clause.literals();
        int size = lits.size();
        this.staticVarSet = new BitSet();
        this.staticVariables = new int[size];
        this.literals = new int[size];
        int i = 0;
        for (Literal literal : lits) {
            int var = solver.variableIndex(literal);
            this.staticVarSet.set(var);
            this.staticVariables[i] = var;
            this.literals[i] = MiniSatStyleSolver.mkLit(var, !literal.phase());
            ++i;
        }
        this.dynamicVarSetHelper = new int[size];
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public SortedSet<Variable> staticVariableSet() {
        return this.clause.variables();
    }

    @Override
    public BitSet dynamicSeparator() {
        return this.separatorBitSet;
    }

    @Override
    public int[] staticClauseIds() {
        return this.staticClauseIds;
    }

    protected boolean isSubsumed() {
        for (int literal : this.literals) {
            if (this.solver.valueOf(literal) != Tristate.TRUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public void countUnsubsumedOccurrences(int[] occurrences) {
        if (!this.isSubsumed()) {
            for (int var : this.staticVariables) {
                int occ = occurrences[var];
                if (occ == -1) continue;
                int n = var;
                occurrences[n] = occurrences[n] + 1;
            }
        }
    }

    @Override
    public int depth() {
        return 1;
    }

    @Override
    public int widestSeparator() {
        return 0;
    }

    @Override
    public List<DTreeLeaf> leafs() {
        ArrayList<DTreeLeaf> result = new ArrayList<DTreeLeaf>();
        result.add(this);
        return result;
    }

    public Formula clause() {
        return this.clause;
    }

    public String toString() {
        return String.format("DTreeLeaf: %d, %s", this.id, this.clause);
    }

    public int[] literals() {
        return this.literals;
    }

    public int clauseSize() {
        return this.clauseSize;
    }

    public int getId() {
        return this.id;
    }
}

