/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.knowledgecompilation.dnnf.DnnfSatSolver;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.sat.MiniSat2Solver;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class DnnfMiniSatStyleSolver
extends MiniSat2Solver
implements DnnfSatSolver {
    protected boolean newlyImpliedDirty = false;
    protected int assertionLevel = -1;
    protected LNGIntVector lastLearnt = null;
    protected final FormulaFactory f;
    protected final Tristate[] assignment;
    protected final List<Literal> impliedOperands;

    public DnnfMiniSatStyleSolver(FormulaFactory f, int numberOfVariables) {
        this.f = f;
        this.assignment = new Tristate[2 * numberOfVariables];
        Arrays.fill((Object[])this.assignment, (Object)Tristate.UNDEF);
        this.impliedOperands = new ArrayList<Literal>();
    }

    @Override
    public boolean start() {
        this.newlyImpliedDirty = true;
        return this.propagate() == null;
    }

    @Override
    public Tristate valueOf(int lit) {
        return this.assignment[lit];
    }

    @Override
    public int variableIndex(Literal lit) {
        return this.idxForName(lit.name());
    }

    @Override
    public Literal litForIdx(int var) {
        return this.f.literal((String)this.idx2name.get(var), true);
    }

    public static int var(int lit) {
        return MiniSatStyleSolver.var(lit);
    }

    public static boolean phase(int lit) {
        return !DnnfMiniSatStyleSolver.sign(lit);
    }

    @Override
    public void add(Formula formula) {
        Formula cnf = formula.cnf();
        switch (cnf.type()) {
            case TRUE: {
                break;
            }
            case FALSE: 
            case LITERAL: 
            case OR: {
                this.addClause(this.generateClauseVector(cnf.literals()), null);
                break;
            }
            case AND: {
                for (Formula op : cnf) {
                    this.addClause(this.generateClauseVector(op.literals()), null);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Input formula ist not a valid CNF: " + cnf);
            }
        }
    }

    protected LNGIntVector generateClauseVector(Collection<Literal> literals) {
        LNGIntVector clauseVec = new LNGIntVector(literals.size());
        for (Literal lit : literals) {
            int index = this.idxForName(lit.name());
            if (index == -1) {
                index = this.newVar(false, true);
                this.addName(lit.name(), index);
            }
            int litNum = lit.phase() ? index * 2 : index * 2 ^ 1;
            clauseVec.push(litNum);
        }
        return clauseVec;
    }

    @Override
    public boolean decide(int var, boolean phase) {
        this.newlyImpliedDirty = true;
        int lit = DnnfMiniSatStyleSolver.mkLit(var, !phase);
        this.trailLim.push(this.trail.size());
        this.uncheckedEnqueue(lit, null);
        return this.propagateAfterDecide();
    }

    @Override
    public void undoDecide(int var) {
        this.newlyImpliedDirty = false;
        this.cancelUntil(((MSVariable)this.vars.get(var)).level() - 1);
    }

    @Override
    public boolean atAssertionLevel() {
        return this.decisionLevel() == this.assertionLevel;
    }

    @Override
    public boolean assertCdLiteral() {
        this.newlyImpliedDirty = true;
        if (!this.atAssertionLevel()) {
            throw new IllegalStateException("assertCdLiteral called although not at assertion level!");
        }
        if (this.lastLearnt.size() == 1) {
            this.uncheckedEnqueue(this.lastLearnt.get(0), null);
            this.unitClauses.push(this.lastLearnt.get(0));
        } else {
            MSClause cr = new MSClause(this.lastLearnt, true);
            this.learnts.push(cr);
            this.attachClause(cr);
            if (!this.incremental) {
                this.claBumpActivity(cr);
            }
            this.uncheckedEnqueue(this.lastLearnt.get(0), cr);
        }
        this.decayActivities();
        return this.propagateAfterDecide();
    }

    @Override
    public Formula newlyImplied(BitSet knownVariables) {
        this.impliedOperands.clear();
        if (this.newlyImpliedDirty) {
            int limit = this.trailLim.empty() ? -1 : this.trailLim.back();
            for (int i = this.trail.size() - 1; i > limit; --i) {
                int lit = this.trail.get(i);
                if (!knownVariables.get(DnnfMiniSatStyleSolver.var(lit))) continue;
                this.impliedOperands.add(this.intToLiteral(lit));
            }
        }
        this.newlyImpliedDirty = false;
        return this.f.and(this.impliedOperands);
    }

    protected Literal intToLiteral(int lit) {
        String name = this.nameForIdx(DnnfMiniSatStyleSolver.var(lit));
        return this.f.literal(name, !DnnfMiniSatStyleSolver.sign(lit));
    }

    protected boolean propagateAfterDecide() {
        MSClause conflict = this.propagate();
        if (conflict != null) {
            this.handleConflict(conflict);
            return false;
        }
        return true;
    }

    @Override
    protected void uncheckedEnqueue(int lit, MSClause reason) {
        this.assignment[lit] = Tristate.TRUE;
        this.assignment[lit ^ 1] = Tristate.FALSE;
        super.uncheckedEnqueue(lit, reason);
    }

    @Override
    protected void cancelUntil(int level) {
        if (this.decisionLevel() > level) {
            for (int c = this.trail.size() - 1; c >= this.trailLim.get(level); --c) {
                int l = this.trail.get(c);
                this.assignment[l] = Tristate.UNDEF;
                this.assignment[l ^ 1] = Tristate.UNDEF;
                int x = DnnfMiniSatStyleSolver.var(l);
                MSVariable v = (MSVariable)this.vars.get(x);
                v.assign(Tristate.UNDEF);
                v.setPolarity(DnnfMiniSatStyleSolver.sign(this.trail.get(c)));
                this.insertVarOrder(x);
            }
            this.qhead = this.trailLim.get(level);
            this.trail.removeElements(this.trail.size() - this.trailLim.get(level));
            this.trailLim.removeElements(this.trailLim.size() - level);
        }
    }

    protected void handleConflict(MSClause conflict) {
        if (this.decisionLevel() > 0) {
            this.lastLearnt = new LNGIntVector();
            this.analyze(conflict, this.lastLearnt);
            this.assertionLevel = this.analyzeBtLevel;
        } else {
            this.cancelUntil(0);
            this.lastLearnt = null;
            this.assertionLevel = -1;
        }
    }
}

