/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf;

import java.util.TreeSet;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.dnnf.DnnfCompiler;
import org.logicng.knowledgecompilation.dnnf.datastructures.Dnnf;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.MinFillDTreeGenerator;
import org.logicng.transformations.cnf.CNFSubsumption;
import org.logicng.transformations.simplification.BackboneSimplifier;

public class DnnfFactory {
    protected final BackboneSimplifier backboneSimplifier = new BackboneSimplifier();
    protected final CNFSubsumption subsumption = new CNFSubsumption();

    public Dnnf compile(Formula formula) {
        TreeSet<Variable> originalVariables = new TreeSet<Variable>(formula.variables());
        Formula cnf = formula.cnf();
        originalVariables.addAll(cnf.variables());
        Formula simplifedFormula = this.simplifyFormula(cnf);
        DnnfCompiler compiler = new DnnfCompiler(simplifedFormula);
        Formula dnnf = compiler.compile(new MinFillDTreeGenerator());
        return new Dnnf(originalVariables, dnnf);
    }

    protected Formula simplifyFormula(Formula formula) {
        return formula.transform(this.backboneSimplifier).transform(this.subsumption);
    }
}

