/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.dnnf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.handlers.DnnfCompilationHandler;
import org.logicng.knowledgecompilation.dnnf.DnnfMiniSatStyleSolver;
import org.logicng.knowledgecompilation.dnnf.DnnfSatSolver;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTree;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeGenerator;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeLeaf;
import org.logicng.knowledgecompilation.dnnf.datastructures.dtree.DTreeNode;
import org.logicng.predicates.satisfiability.SATPredicate;
import org.logicng.solvers.sat.MiniSatStyleSolver;
import org.logicng.util.Pair;

public class DnnfCompiler {
    protected final FormulaFactory f;
    protected final Formula cnf;
    protected final Formula unitClauses;
    protected final Formula nonUnitClauses;
    protected final DnnfSatSolver solver;
    protected final int numberOfVariables;
    protected final Map<BitSet, Formula> cache;
    protected DnnfCompilationHandler handler;
    protected BitSet[][] localCacheKeys;
    protected int[][][] localOccurrences;
    protected final List<Formula> leafResultOperands;
    protected final List<Literal> leafCurrentLiterals;

    public DnnfCompiler(Formula formula) {
        this.f = formula.factory();
        this.cnf = formula;
        Pair<Formula, Formula> pair = this.initializeClauses();
        this.unitClauses = this.f.and(pair.first());
        this.nonUnitClauses = this.f.and(pair.second());
        this.solver = new DnnfMiniSatStyleSolver(this.f, this.cnf.variables().size());
        this.solver.add(this.cnf);
        this.numberOfVariables = this.cnf.variables().size();
        this.cache = new HashMap<BitSet, Formula>();
        int maxClauseSize = this.computeMaxClauseSize(this.cnf);
        this.leafResultOperands = new ArrayList<Formula>(maxClauseSize);
        this.leafCurrentLiterals = new ArrayList<Literal>(maxClauseSize);
    }

    public Formula compile(DTreeGenerator generator) {
        return this.compile(generator, null);
    }

    public Formula compile(DTreeGenerator generator, DnnfCompilationHandler handler) {
        if (!this.cnf.holds(new SATPredicate(this.f))) {
            return this.f.falsum();
        }
        DTree dTree = this.generateDTree(generator);
        return this.compile(dTree, handler);
    }

    protected int computeMaxClauseSize(Formula cnf) {
        switch (cnf.type()) {
            case OR: {
                return cnf.numberOfOperands();
            }
            case AND: {
                int max = 1;
                for (Formula op : cnf) {
                    if (op.numberOfOperands() <= max) continue;
                    max = op.numberOfOperands();
                }
                return max;
            }
        }
        return 1;
    }

    protected Pair<Formula, Formula> initializeClauses() {
        ArrayList<Formula> units = new ArrayList<Formula>();
        ArrayList<Formula> nonUnits = new ArrayList<Formula>();
        switch (this.cnf.type()) {
            case AND: {
                for (Formula clause : this.cnf) {
                    if (clause.isAtomicFormula()) {
                        units.add(clause);
                        continue;
                    }
                    nonUnits.add(clause);
                }
                break;
            }
            case OR: {
                nonUnits.add(this.cnf);
                break;
            }
            default: {
                units.add(this.cnf);
            }
        }
        return new Pair<Formula, Formula>(this.f.and(units), this.f.and(nonUnits));
    }

    protected DTree generateDTree(DTreeGenerator generator) {
        if (this.nonUnitClauses.isAtomicFormula()) {
            return null;
        }
        DTree tree = generator.generate(this.nonUnitClauses);
        tree.initialize(this.solver);
        return tree;
    }

    protected Formula compile(DTree dTree, DnnfCompilationHandler handler) {
        Formula result;
        if (this.nonUnitClauses.isAtomicFormula()) {
            return this.cnf;
        }
        if (!this.solver.start()) {
            return this.f.falsum();
        }
        this.initializeCaches(dTree);
        this.handler = handler;
        if (handler != null) {
            handler.started();
        }
        try {
            result = this.cnf2Ddnnf(dTree);
        }
        catch (TimeoutException e) {
            result = null;
        }
        this.handler = null;
        return result == null ? null : this.f.and(this.unitClauses, result);
    }

    protected void initializeCaches(DTree dTree) {
        int depth = dTree.depth() + 1;
        int sep = dTree.widestSeparator() + 1;
        int variables = this.cnf.variables().size();
        this.localCacheKeys = new BitSet[depth][sep];
        this.localOccurrences = new int[depth][sep][variables];
        for (int i = 0; i < depth; ++i) {
            for (int j = 0; j < sep; ++j) {
                this.localCacheKeys[i][j] = new BitSet(dTree.size() + variables);
                Arrays.fill(this.localOccurrences[i][j], -1);
            }
        }
    }

    protected Formula cnf2Ddnnf(DTree tree) throws TimeoutException {
        return this.cnf2Ddnnf(tree, 0);
    }

    protected Formula cnf2Ddnnf(DTree tree, int currentShannons) throws TimeoutException {
        BitSet separator = tree.dynamicSeparator();
        Formula implied = this.newlyImpliedLiterals(tree.staticVarSet());
        if (separator.isEmpty()) {
            if (tree instanceof DTreeLeaf) {
                return this.f.and(implied, this.leaf2Ddnnf((DTreeLeaf)tree));
            }
            return this.conjoin(implied, (DTreeNode)tree, currentShannons);
        }
        int var = this.chooseShannonVariable(tree, separator, currentShannons);
        if (this.handler != null && !this.handler.shannonExpansion()) {
            throw new TimeoutException();
        }
        Formula positiveDnnf = this.f.falsum();
        if (this.solver.decide(var, true)) {
            positiveDnnf = this.cnf2Ddnnf(tree, currentShannons + 1);
        }
        this.solver.undoDecide(var);
        if (positiveDnnf == this.f.falsum()) {
            if (this.solver.atAssertionLevel() && this.solver.assertCdLiteral()) {
                return this.cnf2Ddnnf(tree);
            }
            return this.f.falsum();
        }
        Formula negativeDnnf = this.f.falsum();
        if (this.solver.decide(var, false)) {
            negativeDnnf = this.cnf2Ddnnf(tree, currentShannons + 1);
        }
        this.solver.undoDecide(var);
        if (negativeDnnf == this.f.falsum()) {
            if (this.solver.atAssertionLevel() && this.solver.assertCdLiteral()) {
                return this.cnf2Ddnnf(tree);
            }
            return this.f.falsum();
        }
        Literal lit = this.solver.litForIdx(var);
        Formula positiveBranch = this.f.and(lit, positiveDnnf);
        Formula negativeBranch = this.f.and(lit.negate(), negativeDnnf);
        return this.f.and(implied, this.f.or(positiveBranch, negativeBranch));
    }

    protected int chooseShannonVariable(DTree tree, BitSet separator, int currentShannons) {
        int[] occurrences = this.localOccurrences[tree.depth()][currentShannons];
        for (int i = 0; i < occurrences.length; ++i) {
            occurrences[i] = separator.get(i) ? 0 : -1;
        }
        tree.countUnsubsumedOccurrences(occurrences);
        int max = -1;
        int maxVal = -1;
        int i = separator.nextSetBit(0);
        while (i != -1) {
            int val = occurrences[i];
            if (val > maxVal) {
                max = i;
                maxVal = val;
            }
            i = separator.nextSetBit(i + 1);
        }
        return max;
    }

    protected Formula conjoin(Formula implied, DTreeNode tree, int currentShannons) throws TimeoutException {
        Formula right;
        Formula left;
        if (implied == this.f.falsum() || (left = this.cnfAux(tree.left(), currentShannons)) == this.f.falsum() || (right = this.cnfAux(tree.right(), currentShannons)) == this.f.falsum()) {
            return this.f.falsum();
        }
        return this.f.and(implied, left, right);
    }

    protected Formula cnfAux(DTree tree, int currentShannons) throws TimeoutException {
        if (tree instanceof DTreeLeaf) {
            return this.leaf2Ddnnf((DTreeLeaf)tree);
        }
        BitSet key = this.computeCacheKey((DTreeNode)tree, currentShannons);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        Formula dnnf = this.cnf2Ddnnf(tree);
        if (dnnf != this.f.falsum()) {
            this.cache.put((BitSet)key.clone(), dnnf);
        }
        return dnnf;
    }

    protected BitSet computeCacheKey(DTreeNode tree, int currentShannons) {
        BitSet key = this.localCacheKeys[tree.depth()][currentShannons];
        key.clear();
        tree.cacheKey(key, this.numberOfVariables);
        return key;
    }

    protected Formula leaf2Ddnnf(DTreeLeaf leaf) {
        Iterator literals = leaf.clause().literals().iterator();
        this.leafResultOperands.clear();
        this.leafCurrentLiterals.clear();
        int index = 0;
        while (literals.hasNext()) {
            Literal lit = (Literal)literals.next();
            switch (this.solver.valueOf(MiniSatStyleSolver.mkLit(this.solver.variableIndex(lit), !lit.phase()))) {
                case TRUE: {
                    return this.f.verum();
                }
                case UNDEF: {
                    this.leafCurrentLiterals.add(lit);
                    this.leafResultOperands.add(this.f.and(this.leafCurrentLiterals));
                    this.leafCurrentLiterals.set(index, lit.negate());
                    ++index;
                }
            }
        }
        return this.f.or(this.leafResultOperands);
    }

    protected Formula newlyImpliedLiterals(BitSet knownVariables) {
        return this.solver.newlyImplied(knownVariables);
    }
}

