/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.orderings;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.functions.VariableProfileFunction;
import org.logicng.knowledgecompilation.bdds.orderings.DFSOrdering;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public final class MinToMaxOrdering
implements VariableOrderingProvider {
    private final VariableProfileFunction profileFunction = new VariableProfileFunction();
    private final DFSOrdering dfsOrdering = new DFSOrdering();

    @Override
    public List<Variable> getOrder(Formula formula) {
        Map<Variable, Integer> profile = formula.apply(this.profileFunction);
        List<Variable> dfs = this.dfsOrdering.getOrder(formula);
        Comparator comparator = (o1, o2) -> {
            int occComp = ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());
            if (occComp != 0) {
                return -occComp;
            }
            int index1 = dfs.indexOf(o1.getKey());
            int index2 = dfs.indexOf(o2.getKey());
            return index1 - index2;
        };
        Map<Variable, Integer> sortedProfile = MinToMaxOrdering.sortProfileByOccurrence(profile, comparator);
        ArrayList<Variable> order = new ArrayList<Variable>(sortedProfile.size());
        for (Map.Entry<Variable, Integer> entry : sortedProfile.entrySet()) {
            order.add(entry.getKey());
        }
        return order;
    }

    static Map<Variable, Integer> sortProfileByOccurrence(Map<Variable, Integer> map, Comparator<Map.Entry<Variable, Integer>> comparator) {
        ArrayList<Map.Entry<Variable, Integer>> list = new ArrayList<Map.Entry<Variable, Integer>>(map.entrySet());
        list.sort(comparator);
        LinkedHashMap<Variable, Integer> result = new LinkedHashMap<Variable, Integer>();
        for (Map.Entry entry : list) {
            result.put((Variable)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }
}

