/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.orderings;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.functions.VariableProfileFunction;
import org.logicng.knowledgecompilation.bdds.orderings.DFSOrdering;
import org.logicng.knowledgecompilation.bdds.orderings.MinToMaxOrdering;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public final class MaxToMinOrdering
implements VariableOrderingProvider {
    private final VariableProfileFunction profileFunction = new VariableProfileFunction();
    private final DFSOrdering dfsOrdering = new DFSOrdering();

    @Override
    public List<Variable> getOrder(Formula formula) {
        Map<Variable, Integer> profile = formula.apply(this.profileFunction);
        List<Variable> dfs = this.dfsOrdering.getOrder(formula);
        Comparator comparator = (o1, o2) -> {
            int occComp = ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());
            if (occComp != 0) {
                return occComp;
            }
            int index1 = dfs.indexOf(o1.getKey());
            int index2 = dfs.indexOf(o2.getKey());
            return index1 - index2;
        };
        Map<Variable, Integer> sortedProfile = MinToMaxOrdering.sortProfileByOccurrence(profile, comparator);
        ArrayList<Variable> order = new ArrayList<Variable>(sortedProfile.size());
        for (Map.Entry<Variable, Integer> entry : sortedProfile.entrySet()) {
            order.add(entry.getKey());
        }
        return order;
    }
}

