/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.orderings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Variable;
import org.logicng.graphs.datastructures.Hypergraph;
import org.logicng.graphs.datastructures.HypergraphNode;
import org.logicng.graphs.generators.HypergraphGenerator;
import org.logicng.knowledgecompilation.bdds.orderings.DFSOrdering;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public final class ForceOrdering
implements VariableOrderingProvider {
    private static final Comparator<? super Map.Entry<HypergraphNode<Variable>, Double>> COMPARATOR = Map.Entry.comparingByValue();
    private final DFSOrdering dfsOrdering = new DFSOrdering();

    @Override
    public List<Variable> getOrder(Formula formula) {
        TreeSet<Variable> originalVariables = new TreeSet<Variable>(formula.variables());
        Formula nnf = formula.nnf();
        originalVariables.addAll(nnf.variables());
        Formula cnf = nnf.cnf();
        Hypergraph<Variable> hypergraph = HypergraphGenerator.fromCNF(cnf);
        HashMap<Variable, HypergraphNode<Variable>> nodes = new HashMap<Variable, HypergraphNode<Variable>>();
        for (HypergraphNode<Variable> node : hypergraph.nodes()) {
            nodes.put(node.content(), node);
        }
        List<Variable> ordering = this.force(cnf, hypergraph, nodes).stream().filter(originalVariables::contains).collect(Collectors.toList());
        originalVariables.stream().filter(v -> !ordering.contains(v)).forEach(ordering::add);
        return ordering;
    }

    private List<Variable> force(Formula formula, Hypergraph<Variable> hypergraph, Map<Variable, HypergraphNode<Variable>> nodes) {
        LinkedHashMap<HypergraphNode<Variable>, Double> newLocations;
        LinkedHashMap lastOrdering;
        LinkedHashMap initialOrdering;
        LinkedHashMap currentOrdering = initialOrdering = this.createInitialOrdering(formula, nodes);
        do {
            lastOrdering = currentOrdering;
            newLocations = new LinkedHashMap<HypergraphNode<Variable>, Double>();
            for (HypergraphNode<Variable> hypergraphNode : hypergraph.nodes()) {
                newLocations.put(hypergraphNode, hypergraphNode.computeTentativeNewLocation(lastOrdering));
            }
        } while (this.shouldProceed(lastOrdering, currentOrdering = this.orderingFromTentativeNewLocations(newLocations)));
        Variable[] ordering = new Variable[currentOrdering.size()];
        for (Map.Entry entry : currentOrdering.entrySet()) {
            ordering[((Integer)entry.getValue()).intValue()] = (Variable)((HypergraphNode)entry.getKey()).content();
        }
        return Arrays.asList(ordering);
    }

    private LinkedHashMap<HypergraphNode<Variable>, Integer> createInitialOrdering(Formula formula, Map<Variable, HypergraphNode<Variable>> nodes) {
        LinkedHashMap<HypergraphNode<Variable>, Integer> initialOrdering = new LinkedHashMap<HypergraphNode<Variable>, Integer>();
        List<Variable> dfsOrder = this.dfsOrdering.getOrder(formula);
        for (int i = 0; i < dfsOrder.size(); ++i) {
            initialOrdering.put(nodes.get(dfsOrder.get(i)), i);
        }
        return initialOrdering;
    }

    private LinkedHashMap<HypergraphNode<Variable>, Integer> orderingFromTentativeNewLocations(LinkedHashMap<HypergraphNode<Variable>, Double> newLocations) {
        LinkedHashMap<HypergraphNode<Variable>, Integer> ordering = new LinkedHashMap<HypergraphNode<Variable>, Integer>();
        ArrayList<Map.Entry<HypergraphNode<Variable>, Double>> list = new ArrayList<Map.Entry<HypergraphNode<Variable>, Double>>(newLocations.entrySet());
        list.sort(COMPARATOR);
        int count = 0;
        for (Map.Entry entry : list) {
            ordering.put((HypergraphNode<Variable>)entry.getKey(), count++);
        }
        return ordering;
    }

    private boolean shouldProceed(Map<HypergraphNode<Variable>, Integer> lastOrdering, Map<HypergraphNode<Variable>, Integer> currentOrdering) {
        return !lastOrdering.equals(currentOrdering);
    }
}

