/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.orderings;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public final class DFSOrdering
implements VariableOrderingProvider {
    @Override
    public List<Variable> getOrder(Formula formula) {
        LinkedHashSet<Variable> order = new LinkedHashSet<Variable>(formula.variables().size());
        this.dfs(formula, order);
        return new ArrayList<Variable>(order);
    }

    private void dfs(Formula formula, LinkedHashSet<Variable> variables) {
        switch (formula.type()) {
            case LITERAL: {
                variables.add(((Literal)formula).variable());
                break;
            }
            case NOT: {
                this.dfs(((Not)formula).operand(), variables);
                break;
            }
            case IMPL: 
            case EQUIV: {
                BinaryOperator op = (BinaryOperator)formula;
                this.dfs(op.left(), variables);
                this.dfs(op.right(), variables);
                break;
            }
            case AND: 
            case OR: {
                for (Formula o : formula) {
                    this.dfs(o, variables);
                }
                break;
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                for (Literal lit : pbc.operands()) {
                    variables.add(lit.variable());
                }
                break;
            }
        }
    }
}

