/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.orderings;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.orderings.VariableOrderingProvider;

public final class BFSOrdering
implements VariableOrderingProvider {
    @Override
    public List<Variable> getOrder(Formula formula) {
        return new ArrayList<Variable>(this.bfs(formula));
    }

    private LinkedHashSet<Variable> bfs(Formula formula) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        LinkedList<Formula> queue = new LinkedList<Formula>();
        queue.add(formula);
        block7: while (!queue.isEmpty()) {
            Formula current = (Formula)queue.remove();
            switch (current.type()) {
                case LITERAL: {
                    Literal lit = (Literal)current;
                    if (lit.phase()) {
                        variables.add(lit.variable());
                        break;
                    }
                    queue.add(lit.variable());
                    break;
                }
                case NOT: {
                    queue.add(((Not)current).operand());
                    break;
                }
                case IMPL: 
                case EQUIV: {
                    BinaryOperator op = (BinaryOperator)current;
                    queue.add(op.left());
                    queue.add(op.right());
                    break;
                }
                case AND: 
                case OR: {
                    for (Formula operand : current) {
                        queue.add(operand);
                    }
                    continue block7;
                }
                case PBC: {
                    PBConstraint pbc = (PBConstraint)current;
                    for (Literal literal : pbc.operands()) {
                        variables.add(literal.variable());
                    }
                    break;
                }
            }
        }
        return variables;
    }
}

