/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

public class BDDTree {
    protected int first;
    protected int last;
    protected int pos;
    protected int[] seq;
    protected boolean fixed;
    protected final int id;
    protected BDDTree next;
    protected BDDTree prev;
    protected BDDTree nextlevel;

    public BDDTree(int id) {
        this.id = id;
        this.first = -1;
        this.last = -1;
        this.fixed = true;
        this.next = null;
        this.prev = null;
        this.nextlevel = null;
        this.seq = null;
    }

    public static BDDTree addRange(BDDTree tree, int first, int last, boolean fixed, int id, int[] level2var) {
        return BDDTree.addRangeRec(tree, null, first, last, fixed, id, level2var);
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public int getLast() {
        return this.last;
    }

    public void setLast(int last) {
        this.last = last;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int[] getSeq() {
        return this.seq;
    }

    public void setSeq(int[] seq) {
        this.seq = seq;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int getId() {
        return this.id;
    }

    public BDDTree getNext() {
        return this.next;
    }

    public void setNext(BDDTree next) {
        this.next = next;
    }

    public BDDTree getPrev() {
        return this.prev;
    }

    public void setPrev(BDDTree prev) {
        this.prev = prev;
    }

    public BDDTree getNextlevel() {
        return this.nextlevel;
    }

    public void setNextlevel(BDDTree nextlevel) {
        this.nextlevel = nextlevel;
    }

    public static BDDTree addRangeRec(BDDTree t, BDDTree prev, int first, int last, boolean fixed, int id, int[] level2var) {
        if (first < 0 || last < 0 || last < first) {
            return null;
        }
        if (t == null) {
            t = new BDDTree(id);
            t.first = first;
            t.fixed = fixed;
            t.seq = new int[last - first + 1];
            t.last = last;
            t.updateSeq(level2var);
            t.prev = prev;
            return t;
        }
        if (first == t.first && last == t.last) {
            return t;
        }
        if (last < t.first) {
            BDDTree tnew = new BDDTree(id);
            tnew.first = first;
            tnew.last = last;
            tnew.fixed = fixed;
            tnew.seq = new int[last - first + 1];
            tnew.updateSeq(level2var);
            tnew.next = t;
            tnew.prev = t.prev;
            t.prev = tnew;
            return tnew;
        }
        if (first > t.last) {
            BDDTree next = BDDTree.addRangeRec(t.next, t, first, last, fixed, id, level2var);
            if (next != null) {
                t.next = next;
            }
            return t;
        }
        if (first >= t.first && last <= t.last) {
            BDDTree nextlevel = BDDTree.addRangeRec(t.nextlevel, null, first, last, fixed, id, level2var);
            if (nextlevel != null) {
                t.nextlevel = nextlevel;
            }
            return t;
        }
        if (first <= t.first) {
            BDDTree thisTree = t;
            while (true) {
                if (last >= thisTree.first && last < thisTree.last) {
                    return null;
                }
                if (thisTree.next == null || last < thisTree.next.first) {
                    BDDTree tnew = new BDDTree(id);
                    tnew.first = first;
                    tnew.last = last;
                    tnew.fixed = fixed;
                    tnew.seq = new int[last - first + 1];
                    tnew.updateSeq(level2var);
                    tnew.nextlevel = t;
                    tnew.next = thisTree.next;
                    tnew.prev = t.prev;
                    if (thisTree.next != null) {
                        thisTree.next.prev = tnew;
                    }
                    thisTree.next = null;
                    t.prev = null;
                    return tnew;
                }
                thisTree = thisTree.next;
            }
        }
        return null;
    }

    protected void updateSeq(int[] bddvar2level) {
        int n;
        int low = this.first;
        for (n = this.first; n <= this.last; ++n) {
            if (bddvar2level[n] >= bddvar2level[low]) continue;
            low = n;
        }
        for (n = this.first; n <= this.last; ++n) {
            this.seq[bddvar2level[n] - bddvar2level[low]] = n;
        }
    }
}

