/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

import java.util.Arrays;
import java.util.Random;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDPrime;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDReorderingMethod;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDTree;
import org.logicng.util.Pair;

public class BDDReordering {
    protected final BDDKernel k;
    protected BDDReorderingMethod reorderMethod;
    protected int bddreorderTimes;
    protected boolean reorderDisabled;
    protected BDDTree varTree;
    protected int blockId;
    protected int[] extRoots;
    protected int extRootSize;
    protected LevelData[] levels;
    protected InteractionMatrix interactionMatrix;
    protected int usednumBefore;
    protected int usednumAfter;
    protected boolean resizedInMakenode;
    protected int usedNodesNextReorder;

    public BDDReordering(BDDKernel k) {
        this.k = k;
        this.init();
    }

    protected void init() {
        this.reorderDisabled = false;
        this.varTree = null;
        this.clrVarBlocks();
        this.setReorderDuringConstruction(BDDReorderingMethod.BDD_REORDER_NONE, 0);
        this.usednumAfter = 0;
        this.usednumBefore = 0;
        this.blockId = 0;
    }

    public void swapVariables(int v1, int v2) {
        if (this.varTree != null) {
            throw new IllegalStateException("Swapping variables is not allowed with variable blocks");
        }
        if (v1 == v2) {
            return;
        }
        if (v1 < 0 || v1 >= this.k.varnum) {
            throw new IllegalArgumentException("Unknown variable number: " + v1);
        }
        if (v2 < 0 || v2 >= this.k.varnum) {
            throw new IllegalArgumentException("Unknown variable number: " + v2);
        }
        int l1 = this.k.var2level[v1];
        int l2 = this.k.var2level[v2];
        if (l1 > l2) {
            int tmp = v1;
            v1 = v2;
            v2 = tmp;
            l1 = this.k.var2level[v1];
            l2 = this.k.var2level[v2];
        }
        this.reorderInit();
        while (this.k.var2level[v1] < l2) {
            this.reorderVardown(v1);
        }
        while (this.k.var2level[v2] > l1) {
            this.reorderVarup(v2);
        }
        this.reorderDone();
    }

    public void reorder(BDDReorderingMethod method) {
        BDDReorderingMethod savemethod = this.reorderMethod;
        int savetimes = this.bddreorderTimes;
        this.reorderMethod = method;
        this.bddreorderTimes = 1;
        BDDTree top = new BDDTree(-1);
        if (this.reorderInit() < 0) {
            return;
        }
        this.usednumBefore = this.k.nodesize - this.k.freenum;
        top.setFirst(0);
        top.setLast(this.k.varnum - 1);
        top.setFixed(false);
        top.setNext(null);
        top.setNextlevel(this.varTree);
        this.reorderBlock(top, method);
        this.varTree = top.getNextlevel();
        this.usednumAfter = this.k.nodesize - this.k.freenum;
        this.reorderDone();
        this.reorderMethod = savemethod;
        this.bddreorderTimes = savetimes;
    }

    public void setReorderDuringConstruction(BDDReorderingMethod method, int num) {
        this.reorderMethod = method;
        this.bddreorderTimes = num;
    }

    public void addVariableBlock(int first, int last, boolean fixed) {
        if (first < 0 || first >= this.k.varnum || last < 0 || last >= this.k.varnum) {
            throw new IllegalArgumentException("invalid var range from " + first + " to " + last);
        }
        BDDTree t = BDDTree.addRange(this.varTree, first, last, fixed, this.blockId, this.k.level2var);
        if (t == null) {
            throw new IllegalStateException("Could not add range to tree");
        }
        this.varTree = t;
        ++this.blockId;
    }

    public void addVariableBlockAll() {
        for (int n = 0; n < this.k.varnum; ++n) {
            this.addVariableBlock(n, n, false);
        }
    }

    protected int var(int n) {
        return this.k.level(n);
    }

    protected int reorderNodenum() {
        return this.k.nodesize - this.k.freenum;
    }

    protected int nodehashReorder(int var, int l, int h) {
        return Math.abs(this.k.pair(l, h) % this.levels[var].size) + this.levels[var].start;
    }

    protected void reorderBlock(BDDTree t, BDDReorderingMethod method) {
        if (t == null) {
            return;
        }
        if (!t.isFixed() && t.getNextlevel() != null) {
            switch (method) {
                case BDD_REORDER_WIN2: {
                    t.setNextlevel(this.reorderWin2(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_WIN2ITE: {
                    t.setNextlevel(this.reorderWin2ite(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_SIFT: {
                    t.setNextlevel(this.reorderSift(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_SIFTITE: {
                    t.setNextlevel(this.reorderSiftite(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_WIN3: {
                    t.setNextlevel(this.reorderWin3(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_WIN3ITE: {
                    t.setNextlevel(this.reorderWin3ite(t.getNextlevel()));
                    break;
                }
                case BDD_REORDER_RANDOM: {
                    t.setNextlevel(this.reorderRandom(t.getNextlevel()));
                }
            }
        }
        for (BDDTree thisTree = t.getNextlevel(); thisTree != null; thisTree = thisTree.getNext()) {
            this.reorderBlock(thisTree, method);
        }
        if (t.getSeq() != null) {
            t.setSeq(Arrays.stream(t.getSeq()).limit(t.getLast() - t.getFirst() + 1).boxed().sorted(this::varseqCmp).mapToInt(i -> i).toArray());
        }
    }

    protected int varseqCmp(Integer aa, Integer bb) {
        int a = this.k.var2level[aa];
        int b = this.k.var2level[bb];
        return Integer.compare(a, b);
    }

    protected void reorderDone() {
        int n;
        for (n = 0; n < this.extRootSize; ++n) {
            this.k.setMark(this.extRoots[n]);
        }
        for (n = 2; n < this.k.nodesize; ++n) {
            if (this.k.marked(n)) {
                this.k.unmark(n);
            } else {
                this.k.setRefcou(n, 0);
            }
            this.k.setLevel(n, this.k.var2level[this.k.level(n)]);
        }
        this.k.gbc();
    }

    protected BDDTree reorderWin2(BDDTree t) {
        BDDTree thisTree = t;
        BDDTree first = t;
        if (t == null) {
            return t;
        }
        while (thisTree.getNext() != null) {
            int best = this.reorderNodenum();
            this.blockdown(thisTree);
            if (best < this.reorderNodenum()) {
                this.blockdown(thisTree.getPrev());
                thisTree = thisTree.getNext();
                continue;
            }
            if (first != thisTree) continue;
            first = thisTree.getPrev();
        }
        return first;
    }

    protected BDDTree reorderWin2ite(BDDTree t) {
        int lastsize;
        BDDTree first = t;
        if (t == null) {
            return t;
        }
        do {
            lastsize = this.reorderNodenum();
            BDDTree thisTree = t;
            while (thisTree.getNext() != null) {
                int best = this.reorderNodenum();
                this.blockdown(thisTree);
                if (best < this.reorderNodenum()) {
                    this.blockdown(thisTree.getPrev());
                    thisTree = thisTree.getNext();
                    continue;
                }
                if (first != thisTree) continue;
                first = thisTree.getPrev();
            }
        } while (this.reorderNodenum() != lastsize);
        return first;
    }

    protected BDDTree reorderWin3(BDDTree t) {
        BDDTree thisTree = t;
        BDDTree first = t;
        if (t == null) {
            return t;
        }
        while (thisTree.getNext() != null) {
            Pair<BDDTree, BDDTree> swapResult = this.reorderSwapwin3(thisTree);
            thisTree = swapResult.first();
            first = swapResult.second() != null ? swapResult.second() : first;
        }
        return first;
    }

    protected BDDTree reorderWin3ite(BDDTree t) {
        int lastsize;
        BDDTree first = t;
        if (t == null) {
            return t;
        }
        do {
            lastsize = this.reorderNodenum();
            BDDTree thisTree = first;
            while (thisTree.getNext() != null && thisTree.getNext().getNext() != null) {
                Pair<BDDTree, BDDTree> swapResult = this.reorderSwapwin3(thisTree);
                thisTree = swapResult.first();
                first = swapResult.second() != null ? swapResult.second() : first;
            }
        } while (this.reorderNodenum() != lastsize);
        return first;
    }

    protected Pair<BDDTree, BDDTree> reorderSwapwin3(BDDTree thisTree) {
        BDDTree first = null;
        boolean setfirst = thisTree.getPrev() == null;
        BDDTree next = thisTree;
        int best = this.reorderNodenum();
        if (thisTree.getNext().getNext() == null) {
            this.blockdown(thisTree);
            if (best < this.reorderNodenum()) {
                this.blockdown(thisTree.getPrev());
                next = thisTree.getNext();
            } else {
                next = thisTree;
                if (setfirst) {
                    first = thisTree.getPrev();
                }
            }
        } else {
            int pos = 0;
            this.blockdown(thisTree);
            ++pos;
            if (best > this.reorderNodenum()) {
                pos = 0;
                best = this.reorderNodenum();
            }
            this.blockdown(thisTree);
            ++pos;
            if (best > this.reorderNodenum()) {
                pos = 0;
                best = this.reorderNodenum();
            }
            thisTree = thisTree.getPrev().getPrev();
            this.blockdown(thisTree);
            ++pos;
            if (best > this.reorderNodenum()) {
                pos = 0;
                best = this.reorderNodenum();
            }
            this.blockdown(thisTree);
            ++pos;
            if (best > this.reorderNodenum()) {
                pos = 0;
                best = this.reorderNodenum();
            }
            thisTree = thisTree.getPrev().getPrev();
            this.blockdown(thisTree);
            ++pos;
            if (best > this.reorderNodenum()) {
                pos = 0;
            }
            if (pos >= 1) {
                thisTree = thisTree.getPrev();
                this.blockdown(thisTree);
                next = thisTree;
                if (setfirst) {
                    first = thisTree.getPrev();
                }
            }
            if (pos >= 2) {
                this.blockdown(thisTree);
                next = thisTree.getPrev();
                if (setfirst) {
                    first = thisTree.getPrev().getPrev();
                }
            }
            if (pos >= 3) {
                thisTree = thisTree.getPrev().getPrev();
                this.blockdown(thisTree);
                next = thisTree;
                if (setfirst) {
                    first = thisTree.getPrev();
                }
            }
            if (pos >= 4) {
                this.blockdown(thisTree);
                next = thisTree.getPrev();
                if (setfirst) {
                    first = thisTree.getPrev().getPrev();
                }
            }
            if (pos >= 5) {
                thisTree = thisTree.getPrev().getPrev();
                this.blockdown(thisTree);
                next = thisTree;
                if (setfirst) {
                    first = thisTree.getPrev();
                }
            }
        }
        return new Pair<BDDTree, BDDTree>(next, first);
    }

    protected BDDTree reorderSiftite(BDDTree t) {
        int lastsize;
        BDDTree first = t;
        if (t == null) {
            return t;
        }
        do {
            lastsize = this.reorderNodenum();
            first = this.reorderSift(first);
        } while (this.reorderNodenum() != lastsize);
        return first;
    }

    protected BDDTree reorderSift(BDDTree t) {
        BDDTree thisTree;
        int num = 0;
        for (thisTree = t; thisTree != null; thisTree = thisTree.getNext()) {
            thisTree.setPos(num++);
        }
        BDDSizePair[] p = new BDDSizePair[num];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new BDDSizePair();
        }
        BDDTree[] seq = new BDDTree[num];
        thisTree = t;
        int n = 0;
        while (thisTree != null) {
            p[n].val = 0;
            for (int v = thisTree.getFirst(); v <= thisTree.getLast(); ++v) {
                p[n].val -= this.levels[v].nodenum;
            }
            p[n].block = thisTree;
            thisTree = thisTree.getNext();
            ++n;
        }
        Arrays.sort(p, 0, num, this::siftTestCmp);
        for (n = 0; n < num; ++n) {
            seq[n] = p[n].block;
        }
        t = this.reorderSiftSeq(t, seq, num);
        return t;
    }

    protected BDDTree reorderSiftSeq(BDDTree t, BDDTree[] seq, int num) {
        if (t == null) {
            return t;
        }
        for (int n = 0; n < num; ++n) {
            this.reorderSiftBestpos(seq[n], num / 2);
        }
        BDDTree thisTree = t;
        while (thisTree.getPrev() != null) {
            thisTree = thisTree.getPrev();
        }
        return thisTree;
    }

    protected void reorderSiftBestpos(BDDTree blk, int middlePos) {
        int best = this.reorderNodenum();
        int maxAllowed = best / 5 + best;
        int bestpos = 0;
        boolean dirIsUp = true;
        if (blk.getPos() > middlePos) {
            dirIsUp = false;
        }
        for (int n = 0; n < 2; ++n) {
            boolean first = true;
            if (dirIsUp) {
                while (blk.getPrev() != null && (this.reorderNodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk.getPrev());
                    --bestpos;
                    if (this.reorderNodenum() >= best) continue;
                    best = this.reorderNodenum();
                    bestpos = 0;
                    maxAllowed = best / 5 + best;
                }
            } else {
                while (blk.getNext() != null && (this.reorderNodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk);
                    ++bestpos;
                    if (this.reorderNodenum() >= best) continue;
                    best = this.reorderNodenum();
                    bestpos = 0;
                    maxAllowed = best / 5 + best;
                }
            }
            dirIsUp = !dirIsUp;
        }
        while (bestpos < 0) {
            this.blockdown(blk);
            ++bestpos;
        }
        while (bestpos > 0) {
            this.blockdown(blk.getPrev());
            --bestpos;
        }
    }

    protected int siftTestCmp(BDDSizePair a, BDDSizePair b) {
        return Integer.compare(a.val, b.val);
    }

    protected BDDTree reorderRandom(BDDTree t) {
        BDDTree thisTree;
        int num = 0;
        if (t == null) {
            return t;
        }
        for (thisTree = t; thisTree != null; thisTree = thisTree.getNext()) {
            ++num;
        }
        BDDTree[] seq = new BDDTree[num];
        num = 0;
        for (thisTree = t; thisTree != null; thisTree = thisTree.getNext()) {
            seq[num++] = thisTree;
        }
        Random random = new Random(42L);
        for (int n = 0; n < 4 * num; ++n) {
            int blk = random.nextInt(num);
            if (seq[blk].getNext() == null) continue;
            this.blockdown(seq[blk]);
        }
        thisTree = t;
        while (thisTree.getPrev() != null) {
            thisTree = thisTree.getPrev();
        }
        return thisTree;
    }

    protected void blockdown(BDDTree left) {
        int n;
        BDDTree right = left.getNext();
        int leftsize = left.getLast() - left.getFirst();
        int rightsize = right.getLast() - right.getFirst();
        int leftstart = this.k.var2level[left.getSeq()[0]];
        int[] lseq = left.getSeq();
        int[] rseq = right.getSeq();
        while (this.k.var2level[lseq[0]] < this.k.var2level[rseq[rightsize]]) {
            for (n = 0; n < leftsize; ++n) {
                if (this.k.var2level[lseq[n]] + 1 == this.k.var2level[lseq[n + 1]] || this.k.var2level[lseq[n]] >= this.k.var2level[rseq[rightsize]]) continue;
                this.reorderVardown(lseq[n]);
            }
            if (this.k.var2level[lseq[leftsize]] >= this.k.var2level[rseq[rightsize]]) continue;
            this.reorderVardown(lseq[leftsize]);
        }
        while (this.k.var2level[rseq[0]] > leftstart) {
            for (n = rightsize; n > 0; --n) {
                if (this.k.var2level[rseq[n]] - 1 == this.k.var2level[rseq[n - 1]] || this.k.var2level[rseq[n]] <= leftstart) continue;
                this.reorderVarup(rseq[n]);
            }
            if (this.k.var2level[rseq[0]] <= leftstart) continue;
            this.reorderVarup(rseq[0]);
        }
        left.setNext(right.getNext());
        right.setPrev(left.getPrev());
        left.setPrev(right);
        right.setNext(left);
        if (right.getPrev() != null) {
            right.getPrev().setNext(right);
        }
        if (left.getNext() != null) {
            left.getNext().setPrev(left);
        }
        n = left.getPos();
        left.setPos(right.getPos());
        right.setPos(n);
    }

    protected void reorderVarup(int var) {
        if (var < 0 || var >= this.k.varnum) {
            throw new IllegalStateException("Illegal variable in reordering");
        }
        if (this.k.var2level[var] != 0) {
            this.reorderVardown(this.k.level2var[this.k.var2level[var] - 1]);
        }
    }

    protected void reorderVardown(int var) {
        if (var < 0 || var >= this.k.varnum) {
            throw new IllegalStateException("Illegal variable in reordering");
        }
        int level = this.k.var2level[var];
        if (level >= this.k.varnum - 1) {
            return;
        }
        this.resizedInMakenode = false;
        if (this.interactionMatrix.depends(var, this.k.level2var[level + 1]) > 0) {
            int toBeProcessed = this.reorderDownSimple(var);
            this.reorderSwap(toBeProcessed, var);
            this.reorderLocalGbc(var);
        }
        int n = this.k.level2var[level];
        this.k.level2var[level] = this.k.level2var[level + 1];
        this.k.level2var[level + 1] = n;
        n = this.k.var2level[var];
        this.k.var2level[var] = this.k.var2level[this.k.level2var[level]];
        this.k.var2level[this.k.level2var[level]] = n;
        if (this.resizedInMakenode) {
            this.reorderRehashAll();
        }
    }

    protected int reorderDownSimple(int var0) {
        int toBeProcessed = 0;
        int var1 = this.k.level2var[this.k.var2level[var0] + 1];
        int vl0 = this.levels[var0].start;
        int size0 = this.levels[var0].size;
        this.levels[var0].nodenum = 0;
        for (int n = 0; n < size0; ++n) {
            int r = this.k.hash(n + vl0);
            this.k.setHash(n + vl0, 0);
            while (r != 0) {
                int next = this.k.next(r);
                if (this.var(this.k.low(r)) != var1 && this.var(this.k.high(r)) != var1) {
                    this.k.setNext(r, this.k.hash(n + vl0));
                    this.k.setHash(n + vl0, r);
                    ++this.levels[var0].nodenum;
                } else {
                    this.k.setNext(r, toBeProcessed);
                    toBeProcessed = r;
                }
                r = next;
            }
        }
        return toBeProcessed;
    }

    protected void reorderSwap(int toBeProcessed, int var0) {
        int var1 = this.k.level2var[this.k.var2level[var0] + 1];
        while (toBeProcessed > 0) {
            int f11;
            int f10;
            int f01;
            int f00;
            int next = this.k.next(toBeProcessed);
            int f0 = this.k.low(toBeProcessed);
            int f1 = this.k.high(toBeProcessed);
            if (this.var(f0) == var1) {
                f00 = this.k.low(f0);
                f01 = this.k.high(f0);
            } else {
                f00 = f01 = f0;
            }
            if (this.var(f1) == var1) {
                f10 = this.k.low(f1);
                f11 = this.k.high(f1);
            } else {
                f10 = f11 = f1;
            }
            f0 = this.reorderMakenode(var0, f00, f10);
            f1 = this.reorderMakenode(var0, f01, f11);
            this.k.decRef(this.k.low(toBeProcessed));
            this.k.decRef(this.k.high(toBeProcessed));
            this.k.setLevel(toBeProcessed, var1);
            this.k.setLow(toBeProcessed, f0);
            this.k.setHigh(toBeProcessed, f1);
            ++this.levels[var1].nodenum;
            int hash = this.nodehashReorder(this.var(toBeProcessed), this.k.low(toBeProcessed), this.k.high(toBeProcessed));
            this.k.setNext(toBeProcessed, this.k.hash(hash));
            this.k.setHash(hash, toBeProcessed);
            toBeProcessed = next;
        }
    }

    protected int reorderMakenode(int var, int low, int high) {
        if (low == high) {
            this.k.incRef(low);
            return low;
        }
        int hash = this.nodehashReorder(var, low, high);
        int res = this.k.hash(hash);
        while (res != 0) {
            if (this.k.low(res) == low && this.k.high(res) == high) {
                this.k.incRef(res);
                return res;
            }
            res = this.k.next(res);
        }
        if (this.k.freepos == 0) {
            this.k.nodeResize(false);
            this.resizedInMakenode = true;
            assert (this.k.freepos > 0);
        }
        res = this.k.freepos;
        this.k.freepos = this.k.next(this.k.freepos);
        ++this.levels[var].nodenum;
        ++this.k.produced;
        --this.k.freenum;
        this.k.setLevel(res, var);
        this.k.setLow(res, low);
        this.k.setHigh(res, high);
        this.k.setNext(res, this.k.hash(hash));
        this.k.setHash(hash, res);
        this.k.setRefcou(res, 1);
        this.k.incRef(this.k.low(res));
        this.k.incRef(this.k.high(res));
        return res;
    }

    protected void reorderLocalGbc(int var0) {
        int var1 = this.k.level2var[this.k.var2level[var0] + 1];
        int vl1 = this.levels[var1].start;
        int size1 = this.levels[var1].size;
        for (int n = 0; n < size1; ++n) {
            int hash = n + vl1;
            int r = this.k.hash(hash);
            this.k.setHash(hash, 0);
            while (r > 0) {
                int next = this.k.next(r);
                if (this.k.refcou(r) > 0) {
                    this.k.setNext(r, this.k.hash(hash));
                    this.k.setHash(hash, r);
                } else {
                    this.k.decRef(this.k.low(r));
                    this.k.decRef(this.k.high(r));
                    this.k.setLow(r, -1);
                    this.k.setNext(r, this.k.freepos);
                    this.k.freepos = r;
                    --this.levels[var1].nodenum;
                    ++this.k.freenum;
                }
                r = next;
            }
        }
    }

    protected void reorderRehashAll() {
        int n;
        this.reorderSetLevellookup();
        this.k.freepos = 0;
        for (n = this.k.nodesize - 1; n >= 0; --n) {
            this.k.setHash(n, 0);
        }
        for (n = this.k.nodesize - 1; n >= 2; --n) {
            if (this.k.refcou(n) > 0) {
                int hash = this.nodehashReorder(this.var(n), this.k.low(n), this.k.high(n));
                this.k.setNext(n, this.k.hash(hash));
                this.k.setHash(hash, n);
                continue;
            }
            this.k.setNext(n, this.k.freepos);
            this.k.freepos = n;
        }
    }

    protected void reorderSetLevellookup() {
        for (int n = 0; n < this.k.varnum; ++n) {
            this.levels[n].maxsize = this.k.nodesize / this.k.varnum;
            this.levels[n].start = n * this.levels[n].maxsize;
            this.levels[n].size = this.levels[n].maxsize;
            if (this.levels[n].size < 4) continue;
            this.levels[n].size = BDDPrime.primeLTE(this.levels[n].size);
        }
    }

    protected void clrVarBlocks() {
        this.varTree = null;
        this.blockId = 0;
    }

    protected void disableReorder() {
        this.reorderDisabled = true;
    }

    protected void enableReorder() {
        this.reorderDisabled = false;
    }

    protected boolean reorderReady() {
        return this.reorderMethod != BDDReorderingMethod.BDD_REORDER_NONE && this.varTree != null && this.bddreorderTimes != 0 && !this.reorderDisabled;
    }

    protected void reorderAuto() {
        if (!this.reorderReady()) {
            return;
        }
        this.reorder(this.reorderMethod);
        --this.bddreorderTimes;
    }

    protected int reorderInit() {
        this.levels = new LevelData[this.k.varnum];
        for (int n = 0; n < this.k.varnum; ++n) {
            this.levels[n] = new LevelData();
            this.levels[n].start = -1;
            this.levels[n].size = 0;
            this.levels[n].nodenum = 0;
        }
        if (this.markRoots() < 0) {
            return -1;
        }
        this.reorderSetLevellookup();
        this.reorderGbc();
        return 0;
    }

    protected int markRoots() {
        int n;
        int[] dep = new int[this.k.varnum];
        this.extRootSize = 0;
        for (n = 2; n < this.k.nodesize; ++n) {
            this.k.setLevel(n, this.k.level2var[this.k.level(n)]);
            if (this.k.refcou(n) <= 0) continue;
            ++this.extRootSize;
            this.k.setMark(n);
        }
        this.extRoots = new int[this.extRootSize];
        this.interactionMatrix = new InteractionMatrix(this.k.varnum);
        this.extRootSize = 0;
        for (n = 2; n < this.k.nodesize; ++n) {
            if (this.k.marked(n)) {
                this.k.unmarkNode(n);
                this.extRoots[this.extRootSize++] = n;
                dep[this.var((int)n)] = 1;
                ++this.levels[this.var((int)n)].nodenum;
                this.addrefRec(this.k.low(n), dep);
                this.addrefRec(this.k.high(n), dep);
                this.addDependencies(dep);
            }
            this.k.setHash(n, 0);
        }
        this.k.setHash(0, 0);
        this.k.setHash(1, 0);
        return 0;
    }

    protected void reorderGbc() {
        this.k.freepos = 0;
        this.k.freenum = 0;
        for (int n = this.k.nodesize - 1; n >= 2; --n) {
            if (this.k.refcou(n) > 0) {
                int hash = this.nodehashReorder(this.var(n), this.k.low(n), this.k.high(n));
                this.k.setNext(n, this.k.hash(hash));
                this.k.setHash(hash, n);
                continue;
            }
            this.k.setLow(n, -1);
            this.k.setNext(n, this.k.freepos);
            this.k.freepos = n;
            ++this.k.freenum;
        }
    }

    protected void checkReorder() {
        this.reorderAuto();
        this.usedNodesNextReorder = 2 * (this.k.nodesize - this.k.freenum);
        if (this.reorderGain() < 20) {
            this.usedNodesNextReorder += this.usedNodesNextReorder * (20 - this.reorderGain()) / 20;
        }
    }

    protected void addrefRec(int r, int[] dep) {
        if (r < 2) {
            return;
        }
        if (this.k.refcou(r) == 0) {
            --this.k.freenum;
            dep[this.var((int)r) & 0x1FFFFF] = 1;
            ++this.levels[this.var((int)r) & 0x1FFFFF].nodenum;
            this.addrefRec(this.k.low(r), dep);
            this.addrefRec(this.k.high(r), dep);
        } else {
            for (int n = 0; n < this.k.varnum; ++n) {
                int n2 = n;
                dep[n2] = dep[n2] | this.interactionMatrix.depends(this.var(r) & 0x1FFFFF, n);
            }
        }
        this.k.incRef(r);
    }

    protected void addDependencies(int[] dep) {
        for (int n = 0; n < this.k.varnum; ++n) {
            for (int m = n; m < this.k.varnum; ++m) {
                if (dep[n] <= 0 || dep[m] <= 0) continue;
                this.interactionMatrix.set(n, m);
                this.interactionMatrix.set(m, n);
            }
        }
    }

    protected int[] scanset(int r) {
        if (r < 0 || r >= this.k.nodesize || r >= 2 && this.k.low(r) == -1) {
            throw new IllegalArgumentException("Invalid BDD " + r + " as input");
        }
        if (r < 2) {
            return new int[0];
        }
        int num = 0;
        int n = r;
        while (n > 1) {
            ++num;
            n = this.k.high(n);
        }
        int[] varset = new int[num];
        num = 0;
        int n2 = r;
        while (n2 > 1) {
            varset[num++] = this.k.level2var[this.k.level(n2)];
            n2 = this.k.high(n2);
        }
        return varset;
    }

    protected int reorderGain() {
        if (this.usednumBefore == 0) {
            return 0;
        }
        return 100 * (this.usednumBefore - this.usednumAfter) / this.usednumBefore;
    }

    protected static class InteractionMatrix {
        protected final int[][] rows;

        protected InteractionMatrix(int size) {
            this.rows = new int[size][];
            for (int n = 0; n < size; ++n) {
                this.rows[n] = new int[size / 8 + 1];
            }
        }

        protected void set(int a, int b) {
            int[] nArray = this.rows[a];
            int n = b / 8;
            nArray[n] = nArray[n] | 1 << b % 8;
        }

        protected int depends(int a, int b) {
            return this.rows[a][b / 8] & 1 << b % 8;
        }
    }

    protected static class BDDSizePair {
        protected int val;
        protected BDDTree block;

        protected BDDSizePair() {
        }
    }

    protected static class LevelData {
        protected int start;
        protected int size;
        protected int maxsize;
        protected int nodenum;

        protected LevelData() {
        }
    }
}

