/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

import java.util.Random;

public final class BDDPrime {
    static final int CHECKTIMES = 20;
    static final Random rng = new Random();

    private BDDPrime() {
    }

    public static int primeGTE(int num) {
        if (BDDPrime.isEven(num)) {
            ++num;
        }
        while (!BDDPrime.isPrime(num)) {
            num += 2;
        }
        return num;
    }

    public static int primeLTE(int num) {
        if (BDDPrime.isEven(num)) {
            --num;
        }
        while (!BDDPrime.isPrime(num)) {
            num -= 2;
        }
        return num;
    }

    static boolean isEven(int src) {
        return (src & 1) == 0;
    }

    static boolean isPrime(int src) {
        return !BDDPrime.hasEasyFactors(src) && BDDPrime.isMillerRabinPrime(src);
    }

    static boolean hasEasyFactors(int src) {
        return BDDPrime.hasFactor(src, 3) || BDDPrime.hasFactor(src, 5) || BDDPrime.hasFactor(src, 7) || BDDPrime.hasFactor(src, 11) || BDDPrime.hasFactor(src, 13);
    }

    static boolean isMillerRabinPrime(int src) {
        for (int n = 0; n < 20; ++n) {
            int witness = BDDPrime.random(src - 1);
            if (!BDDPrime.isWitness(witness, src)) continue;
            return false;
        }
        return true;
    }

    static boolean isWitness(int witness, int src) {
        int bitNum = BDDPrime.numberOfBits(src - 1) - 1;
        int d = 1;
        for (int i = bitNum; i >= 0; --i) {
            int x = d;
            if ((d = BDDPrime.mulmod(d, d, src)) == 1 && x != 1 && x != src - 1) {
                return true;
            }
            if (!BDDPrime.bitIsSet(src - 1, i)) continue;
            d = BDDPrime.mulmod(d, witness, src);
        }
        return d != 1;
    }

    static int numberOfBits(int src) {
        if (src == 0) {
            return 0;
        }
        for (int b = 31; b > 0; --b) {
            if (!BDDPrime.bitIsSet(src, b)) continue;
            return b + 1;
        }
        return 1;
    }

    static boolean bitIsSet(int src, int b) {
        return (src & 1 << b) != 0;
    }

    static int mulmod(int a, int b, int c) {
        return (int)((long)a * (long)b % (long)c);
    }

    static int random(int i) {
        return rng.nextInt(i) + 1;
    }

    static boolean hasFactor(int src, int n) {
        return src != n && src % n == 0;
    }
}

