/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDCacheEntry;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;

public class BDDOperations {
    protected final BDDKernel k;
    protected byte[] allunsatProfile;
    protected int supportID;
    protected int supportMax;
    protected int[] supportSet;

    public BDDOperations(BDDKernel k) {
        this.k = k;
    }

    public int satOne(int r) {
        if (r < 2) {
            return r;
        }
        this.k.reordering.disableReorder();
        this.k.initRef();
        int res = this.satOneRec(r);
        this.k.reordering.enableReorder();
        return res;
    }

    protected int satOneRec(int r) throws BDDKernel.BddReorderRequest {
        if (this.k.isConst(r)) {
            return r;
        }
        if (this.k.isZero(this.k.low(r))) {
            int res = this.satOneRec(this.k.high(r));
            return this.k.pushRef(this.k.makeNode(this.k.level(r), 0, res));
        }
        int res = this.satOneRec(this.k.low(r));
        return this.k.pushRef(this.k.makeNode(this.k.level(r), res, 0));
    }

    public int satOneSet(int r, int var, int pol) {
        if (this.k.isZero(r)) {
            return r;
        }
        if (!this.k.isConst(pol)) {
            throw new IllegalArgumentException("polarity for satOneSet must be a constant");
        }
        this.k.reordering.disableReorder();
        this.k.initRef();
        int res = this.satOneSetRec(r, var, pol);
        this.k.reordering.enableReorder();
        return res;
    }

    protected int satOneSetRec(int r, int var, int satPolarity) throws BDDKernel.BddReorderRequest {
        if (this.k.isConst(r) && this.k.isConst(var)) {
            return r;
        }
        if (this.k.level(r) < this.k.level(var)) {
            if (this.k.isZero(this.k.low(r))) {
                int res = this.satOneSetRec(this.k.high(r), var, satPolarity);
                return this.k.pushRef(this.k.makeNode(this.k.level(r), 0, res));
            }
            int res = this.satOneSetRec(this.k.low(r), var, satPolarity);
            return this.k.pushRef(this.k.makeNode(this.k.level(r), res, 0));
        }
        if (this.k.level(var) < this.k.level(r)) {
            int res = this.satOneSetRec(r, this.k.high(var), satPolarity);
            if (satPolarity == 1) {
                return this.k.pushRef(this.k.makeNode(this.k.level(var), 0, res));
            }
            return this.k.pushRef(this.k.makeNode(this.k.level(var), res, 0));
        }
        if (this.k.isZero(this.k.low(r))) {
            int res = this.satOneSetRec(this.k.high(r), this.k.high(var), satPolarity);
            return this.k.pushRef(this.k.makeNode(this.k.level(r), 0, res));
        }
        int res = this.satOneSetRec(this.k.low(r), this.k.high(var), satPolarity);
        return this.k.pushRef(this.k.makeNode(this.k.level(r), res, 0));
    }

    public int fullSatOne(int r) {
        if (r == 0) {
            return 0;
        }
        this.k.reordering.disableReorder();
        this.k.initRef();
        int res = this.fullSatOneRec(r);
        for (int v = this.k.level(r) - 1; v >= 0; --v) {
            res = this.k.pushRef(this.k.makeNode(v, res, 0));
        }
        this.k.reordering.enableReorder();
        return res;
    }

    protected int fullSatOneRec(int r) throws BDDKernel.BddReorderRequest {
        if (r < 2) {
            return r;
        }
        if (this.k.low(r) != 0) {
            int res = this.fullSatOneRec(this.k.low(r));
            for (int v = this.k.level(this.k.low(r)) - 1; v > this.k.level(r); --v) {
                res = this.k.pushRef(this.k.makeNode(v, res, 0));
            }
            return this.k.pushRef(this.k.makeNode(this.k.level(r), res, 0));
        }
        int res = this.fullSatOneRec(this.k.high(r));
        for (int v = this.k.level(this.k.high(r)) - 1; v > this.k.level(r); --v) {
            res = this.k.pushRef(this.k.makeNode(v, res, 0));
        }
        return this.k.pushRef(this.k.makeNode(this.k.level(r), 0, res));
    }

    public List<byte[]> allSat(int r) {
        byte[] allsatProfile = new byte[this.k.varnum];
        for (int v = this.k.level(r) - 1; v >= 0; --v) {
            allsatProfile[this.k.level2var[v]] = -1;
        }
        this.k.initRef();
        ArrayList<byte[]> allSat = new ArrayList<byte[]>();
        this.allSatRec(r, allSat, allsatProfile);
        return allSat;
    }

    protected void allSatRec(int r, List<byte[]> models, byte[] allsatProfile) {
        int v;
        if (this.k.isOne(r)) {
            models.add(Arrays.copyOf(allsatProfile, allsatProfile.length));
            return;
        }
        if (this.k.isZero(r)) {
            return;
        }
        if (!this.k.isZero(this.k.low(r))) {
            allsatProfile[this.k.level2var[this.k.level((int)r)]] = 0;
            for (v = this.k.level(this.k.low(r)) - 1; v > this.k.level(r); --v) {
                allsatProfile[this.k.level2var[v]] = -1;
            }
            this.allSatRec(this.k.low(r), models, allsatProfile);
        }
        if (!this.k.isZero(this.k.high(r))) {
            allsatProfile[this.k.level2var[this.k.level((int)r)]] = 1;
            for (v = this.k.level(this.k.high(r)) - 1; v > this.k.level(r); --v) {
                allsatProfile[this.k.level2var[v]] = -1;
            }
            this.allSatRec(this.k.high(r), models, allsatProfile);
        }
    }

    public BigInteger satCount(int r) {
        BigInteger size = BigInteger.valueOf(2L).pow(this.k.level(r));
        return this.satCountRec(r, 2).multiply(size);
    }

    protected BigInteger satCountRec(int root, int miscid) {
        if (root < 2) {
            return BigInteger.valueOf(root);
        }
        BDDCacheEntry entry = this.k.misccache.lookup(root);
        if (entry.a == root && entry.c == miscid) {
            return entry.bdres;
        }
        BigInteger size = BigInteger.ZERO;
        BigInteger s = BigInteger.ONE;
        s = s.multiply(BigInteger.valueOf(2L).pow(this.k.level(this.k.low(root)) - this.k.level(root) - 1));
        size = size.add(s.multiply(this.satCountRec(this.k.low(root), miscid)));
        s = BigInteger.ONE;
        s = s.multiply(BigInteger.valueOf(2L).pow(this.k.level(this.k.high(root)) - this.k.level(root) - 1));
        size = size.add(s.multiply(this.satCountRec(this.k.high(root), miscid)));
        entry.a = root;
        entry.c = miscid;
        entry.bdres = size;
        return size;
    }

    public BigInteger pathCountOne(int r) {
        return this.pathCountRecOne(r, 4);
    }

    protected BigInteger pathCountRecOne(int r, int miscid) {
        if (this.k.isZero(r)) {
            return BigInteger.ZERO;
        }
        if (this.k.isOne(r)) {
            return BigInteger.ONE;
        }
        BDDCacheEntry entry = this.k.misccache.lookup(r);
        if (entry.a == r && entry.c == miscid) {
            return entry.bdres;
        }
        BigInteger size = this.pathCountRecOne(this.k.low(r), miscid).add(this.pathCountRecOne(this.k.high(r), miscid));
        entry.a = r;
        entry.c = miscid;
        entry.bdres = size;
        return size;
    }

    public BigInteger pathCountZero(int r) {
        return this.pathCountRecZero(r, 8);
    }

    protected BigInteger pathCountRecZero(int r, int miscid) {
        if (this.k.isZero(r)) {
            return BigInteger.ONE;
        }
        if (this.k.isOne(r)) {
            return BigInteger.ZERO;
        }
        BDDCacheEntry entry = this.k.misccache.lookup(r);
        if (entry.a == r && entry.c == miscid) {
            return entry.bdres;
        }
        BigInteger size = this.pathCountRecZero(this.k.low(r), miscid).add(this.pathCountRecZero(this.k.high(r), miscid));
        entry.a = r;
        entry.c = miscid;
        entry.bdres = size;
        return size;
    }

    public List<byte[]> allUnsat(int r) {
        this.allunsatProfile = new byte[this.k.varnum];
        for (int v = this.k.level(r) - 1; v >= 0; --v) {
            this.allunsatProfile[this.k.level2var[v]] = -1;
        }
        this.k.initRef();
        ArrayList<byte[]> allUnsat = new ArrayList<byte[]>();
        this.allUnsatRec(r, allUnsat);
        return allUnsat;
    }

    protected void allUnsatRec(int r, List<byte[]> models) {
        int v;
        if (this.k.isZero(r)) {
            models.add(Arrays.copyOf(this.allunsatProfile, this.allunsatProfile.length));
            return;
        }
        if (this.k.isOne(r)) {
            return;
        }
        if (!this.k.isOne(this.k.low(r))) {
            this.allunsatProfile[this.k.level2var[this.k.level((int)r)]] = 0;
            for (v = this.k.level(this.k.low(r)) - 1; v > this.k.level(r); --v) {
                this.allunsatProfile[this.k.level2var[v]] = -1;
            }
            this.allUnsatRec(this.k.low(r), models);
        }
        if (!this.k.isOne(this.k.high(r))) {
            this.allunsatProfile[this.k.level2var[this.k.level((int)r)]] = 1;
            for (v = this.k.level(this.k.high(r)) - 1; v > this.k.level(r); --v) {
                this.allunsatProfile[this.k.level2var[v]] = -1;
            }
            this.allUnsatRec(this.k.high(r), models);
        }
    }

    public int support(int r) {
        int supportMin;
        boolean supportSize = false;
        int res = 1;
        if (r < 2) {
            return 0;
        }
        if (0 < this.k.varnum) {
            this.supportSet = new int[this.k.varnum];
            this.supportID = 0;
        }
        if (this.supportID == 0xFFFFFFF) {
            this.supportID = 0;
        }
        ++this.supportID;
        this.supportMax = supportMin = this.k.level(r);
        this.supportRec(r, this.supportSet);
        this.k.unmark(r);
        this.k.reordering.disableReorder();
        for (int n = this.supportMax; n >= supportMin; --n) {
            if (this.supportSet[n] != this.supportID) continue;
            this.k.addRef(res, null);
            int tmp = this.k.makeNode(n, 0, res);
            this.k.delRef(res);
            res = tmp;
        }
        this.k.reordering.enableReorder();
        return res;
    }

    protected void supportRec(int r, int[] support) {
        if (r < 2) {
            return;
        }
        if ((this.k.level(r) & 0x200000) != 0 || this.k.low(r) == -1) {
            return;
        }
        support[this.k.level((int)r)] = this.supportID;
        if (this.k.level(r) > this.supportMax) {
            this.supportMax = this.k.level(r);
        }
        this.k.setLevel(r, this.k.level(r) | 0x200000);
        this.supportRec(this.k.low(r), support);
        this.supportRec(this.k.high(r), support);
    }

    public int nodeCount(int r) {
        int count = this.k.markCount(r);
        this.k.unmark(r);
        return count;
    }

    public int[] varProfile(int r) {
        int[] varprofile = new int[this.k.varnum];
        this.varProfileRec(r, varprofile);
        this.k.unmark(r);
        return varprofile;
    }

    protected void varProfileRec(int r, int[] varprofile) {
        if (r < 2) {
            return;
        }
        if ((this.k.level(r) & 0x200000) != 0) {
            return;
        }
        int n = this.k.level2var[this.k.level(r)];
        varprofile[n] = varprofile[n] + 1;
        this.k.setLevel(r, this.k.level(r) | 0x200000);
        this.varProfileRec(this.k.low(r), varprofile);
        this.varProfileRec(this.k.high(r), varprofile);
    }

    public List<int[]> allNodes(int r) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        if (r < 2) {
            return result;
        }
        this.k.mark(r);
        for (int n = 0; n < this.k.nodesize; ++n) {
            if ((this.k.level(n) & 0x200000) == 0) continue;
            this.k.setLevel(n, this.k.level(n) & 0x1FFFFF);
            result.add(new int[]{n, this.k.level2var[this.k.level(n)], this.k.low(n), this.k.high(n)});
        }
        return result;
    }
}

