/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Variable;
import org.logicng.handlers.BDDHandler;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDCache;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDCacheEntry;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDPrime;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDReordering;

public class BDDKernel {
    public static final int BDD_ABORT = -1;
    public static final int BDD_TRUE = 1;
    public static final int BDD_FALSE = 0;
    public static final int MAXVAR = 0x1FFFFF;
    public static final int MAXREF = 1023;
    public static final int MARKON = 0x200000;
    public static final int MARKOFF = 0x1FFFFF;
    public static final int MARKHIDE = 0x1FFFFF;
    public static final int CACHEID_RESTRICT = 1;
    public static final int CACHEID_SATCOU = 2;
    public static final int CACHEID_PATHCOU_ONE = 4;
    public static final int CACHEID_PATHCOU_ZERO = 8;
    public static final int CACHEID_FORALL = 1;
    protected final FormulaFactory f;
    protected final SortedMap<Variable, Integer> var2idx;
    protected final SortedMap<Integer, Variable> idx2var;
    protected BDDReordering reordering;
    protected int[] nodes;
    protected int[] vars;
    protected final int minfreenodes;
    protected int gbcollectnum;
    protected final int cachesize;
    protected int nodesize;
    protected final int maxnodeincrease;
    protected int freepos;
    protected int freenum;
    protected long produced;
    protected int varnum;
    protected int[] refstack;
    protected int refstacktop;
    protected int[] level2var;
    protected int[] var2level;
    protected int[] quantvarset;
    protected int quantvarsetID;
    protected int quantlast;
    protected BDDCache applycache;
    protected BDDCache itecache;
    protected BDDCache quantcache;
    protected BDDCache appexcache;
    protected BDDCache replacecache;
    protected BDDCache misccache;

    public BDDKernel(FormulaFactory f, int numVars, int nodeSize, int cacheSize) {
        this.f = f;
        this.var2idx = new TreeMap<Variable, Integer>();
        this.idx2var = new TreeMap<Integer, Variable>();
        this.reordering = new BDDReordering(this);
        this.nodesize = BDDPrime.primeGTE(Math.max(nodeSize, 3));
        this.nodes = new int[this.nodesize * 6];
        this.minfreenodes = 20;
        for (int n = 0; n < this.nodesize; ++n) {
            this.setRefcou(n, 0);
            this.setLow(n, -1);
            this.setHash(n, 0);
            this.setLevel(n, 0);
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodesize - 1, 0);
        this.setRefcou(0, 1023);
        this.setRefcou(1, 1023);
        this.setLow(0, 0);
        this.setHigh(0, 0);
        this.setLow(1, 1);
        this.setHigh(1, 1);
        this.initOperators(Math.max(cacheSize, 3));
        this.freepos = 2;
        this.freenum = this.nodesize - 2;
        this.varnum = 0;
        this.gbcollectnum = 0;
        this.cachesize = cacheSize;
        this.reordering.usedNodesNextReorder = this.nodesize;
        this.maxnodeincrease = 50000;
        this.setNumberOfVars(numVars);
    }

    public BDDKernel(FormulaFactory f, List<Variable> ordering, int nodeSize, int cacheSize) {
        this(f, ordering.size(), nodeSize, cacheSize);
        for (Variable var : ordering) {
            this.getOrAddVarIndex(var);
        }
    }

    protected void setNumberOfVars(int num) {
        if (num < 0 || num > 0x1FFFFF) {
            throw new IllegalArgumentException("Invalid variable number: " + num);
        }
        this.reordering.disableReorder();
        this.vars = new int[num * 2];
        this.level2var = new int[num + 1];
        this.var2level = new int[num + 1];
        this.refstack = new int[num * 2 + 4];
        this.refstacktop = 0;
        while (this.varnum < num) {
            this.vars[this.varnum * 2] = this.pushRef(this.makeNode(this.varnum, 0, 1));
            this.vars[this.varnum * 2 + 1] = this.makeNode(this.varnum, 1, 0);
            this.popref(1);
            this.setRefcou(this.vars[this.varnum * 2], 1023);
            this.setRefcou(this.vars[this.varnum * 2 + 1], 1023);
            this.level2var[this.varnum] = this.varnum;
            this.var2level[this.varnum] = this.varnum;
            ++this.varnum;
        }
        this.setLevel(0, num);
        this.setLevel(1, num);
        this.level2var[num] = num;
        this.var2level[num] = num;
        this.varResize();
        this.reordering.enableReorder();
    }

    public int getOrAddVarIndex(Variable variable) {
        Integer index = (Integer)this.var2idx.get(variable);
        if (index == null) {
            if (this.var2idx.size() >= this.varnum) {
                throw new IllegalArgumentException("No free variables left! You did not set the number of variables high enough.");
            }
            index = this.var2idx.size();
            this.var2idx.put(variable, index);
            this.idx2var.put(index, variable);
        }
        return index;
    }

    public FormulaFactory factory() {
        return this.f;
    }

    public BDDReordering getReordering() {
        return this.reordering;
    }

    public SortedMap<Variable, Integer> var2idx() {
        return this.var2idx;
    }

    public SortedMap<Integer, Variable> idx2var() {
        return this.idx2var;
    }

    public int getIndexForVariable(Variable var) {
        Integer index = (Integer)this.var2idx.get(var);
        return index == null ? -1 : index;
    }

    public Variable getVariableForIndex(int idx) {
        return (Variable)this.idx2var.get(idx);
    }

    public int getLevel(Variable var) {
        Integer idx = (Integer)this.var2idx.get(var);
        return idx != null && idx >= 0 && idx < this.var2level.length ? this.var2level[idx] : -1;
    }

    public int[] getCurrentVarOrder() {
        return Arrays.copyOf(this.level2var, this.level2var.length - 1);
    }

    protected int doWithPotentialReordering(BddOperation operation) {
        try {
            this.initRef();
            return operation.perform();
        }
        catch (BddReorderRequest reorderRequest) {
            this.reordering.checkReorder();
            this.initRef();
            this.reordering.disableReorder();
            try {
                int n = operation.perform();
                return n;
            }
            catch (BddReorderRequest e) {
                throw new IllegalStateException("Must not happen");
            }
            finally {
                this.reordering.enableReorder();
            }
        }
    }

    protected int apply(int l, int r, Operand op) {
        return this.doWithPotentialReordering(() -> this.applyRec(l, r, op));
    }

    protected int applyRec(int l, int r, Operand op) throws BddReorderRequest {
        int res;
        switch (op) {
            case AND: {
                if (l == r) {
                    return l;
                }
                if (this.isZero(l) || this.isZero(r)) {
                    return 0;
                }
                if (this.isOne(l)) {
                    return r;
                }
                if (!this.isOne(r)) break;
                return l;
            }
            case OR: {
                if (l == r) {
                    return l;
                }
                if (this.isOne(l) || this.isOne(r)) {
                    return 1;
                }
                if (this.isZero(l)) {
                    return r;
                }
                if (!this.isZero(r)) break;
                return l;
            }
            case IMP: {
                if (this.isZero(l)) {
                    return 1;
                }
                if (this.isOne(l)) {
                    return r;
                }
                if (!this.isOne(r)) break;
                return 1;
            }
        }
        if (this.isConst(l) && this.isConst(r)) {
            res = op.tt[l << 1 | r];
        } else {
            BDDCacheEntry entry = this.applycache.lookup(this.triple(l, r, op.v));
            if (entry.a == l && entry.b == r && entry.c == op.v) {
                return entry.res;
            }
            if (this.level(l) == this.level(r)) {
                this.pushRef(this.applyRec(this.low(l), this.low(r), op));
                this.pushRef(this.applyRec(this.high(l), this.high(r), op));
                res = this.makeNode(this.level(l), this.readRef(2), this.readRef(1));
            } else if (this.level(l) < this.level(r)) {
                this.pushRef(this.applyRec(this.low(l), r, op));
                this.pushRef(this.applyRec(this.high(l), r, op));
                res = this.makeNode(this.level(l), this.readRef(2), this.readRef(1));
            } else {
                this.pushRef(this.applyRec(l, this.low(r), op));
                this.pushRef(this.applyRec(l, this.high(r), op));
                res = this.makeNode(this.level(r), this.readRef(2), this.readRef(1));
            }
            this.popref(2);
            entry.a = l;
            entry.b = r;
            entry.c = op.v;
            entry.res = res;
        }
        return res;
    }

    public int addRef(int root, BDDHandler handler) {
        if (handler != null && !handler.newRefAdded()) {
            return -1;
        }
        if (root < 2) {
            return root;
        }
        if (root >= this.nodesize) {
            throw new IllegalArgumentException("Not a valid BDD root node: " + root);
        }
        if (this.low(root) == -1) {
            throw new IllegalArgumentException("Not a valid BDD root node: " + root);
        }
        this.incRef(root);
        return root;
    }

    public void delRef(int root) {
        if (root < 2) {
            return;
        }
        if (root >= this.nodesize) {
            throw new IllegalStateException("Cannot dereference a variable > varnum");
        }
        if (this.low(root) == -1) {
            throw new IllegalStateException("Cannot dereference variable -1");
        }
        if (!this.hasref(root)) {
            throw new IllegalStateException("Cannot dereference a variable which has no reference");
        }
        this.decRef(root);
    }

    protected void decRef(int n) {
        if (this.refcou(n) != 1023 && this.refcou(n) > 0) {
            this.setRefcou(n, this.refcou(n) - 1);
        }
    }

    protected void incRef(int n) {
        if (this.refcou(n) < 1023) {
            this.setRefcou(n, this.refcou(n) + 1);
        }
    }

    protected int makeNode(int level, int low, int high) throws BddReorderRequest {
        if (low == high) {
            return low;
        }
        int hash = this.nodehash(level, low, high);
        int res = this.hash(hash);
        while (res != 0) {
            if (this.level(res) == level && this.low(res) == low && this.high(res) == high) {
                return res;
            }
            res = this.next(res);
        }
        if (this.freepos == 0) {
            this.gbc();
            if (this.nodesize - this.freenum >= this.reordering.usedNodesNextReorder && this.reordering.reorderReady()) {
                throw new BddReorderRequest();
            }
            if (this.freenum * 100 / this.nodesize <= this.minfreenodes) {
                this.nodeResize(true);
                hash = this.nodehash(level, low, high);
            }
            if (this.freepos == 0) {
                throw new IllegalStateException("Cannot allocate more space for more nodes.");
            }
        }
        res = this.freepos;
        this.freepos = this.next(this.freepos);
        --this.freenum;
        ++this.produced;
        this.setLevel(res, level);
        this.setLow(res, low);
        this.setHigh(res, high);
        this.setNext(res, this.hash(hash));
        this.setHash(hash, res);
        return res;
    }

    protected void unmark(int i) {
        if (i < 2) {
            return;
        }
        if (!this.marked(i) || this.low(i) == -1) {
            return;
        }
        this.unmarkNode(i);
        this.unmark(this.low(i));
        this.unmark(this.high(i));
    }

    protected int markCount(int i) {
        if (i < 2) {
            return 0;
        }
        if (this.marked(i) || this.low(i) == -1) {
            return 0;
        }
        this.setMark(i);
        int count = 1;
        count += this.markCount(this.low(i));
        return count += this.markCount(this.high(i));
    }

    protected void gbc() {
        int n;
        for (int r = 0; r < this.refstacktop; ++r) {
            this.mark(this.refstack[r]);
        }
        for (n = 0; n < this.nodesize; ++n) {
            if (this.refcou(n) > 0) {
                this.mark(n);
            }
            this.setHash(n, 0);
        }
        this.freepos = 0;
        this.freenum = 0;
        for (n = this.nodesize - 1; n >= 2; --n) {
            if ((this.level(n) & 0x200000) != 0 && this.low(n) != -1) {
                this.setLevel(n, this.level(n) & 0x1FFFFF);
                int hash = this.nodehash(this.level(n), this.low(n), this.high(n));
                this.setNext(n, this.hash(hash));
                this.setHash(hash, n);
                continue;
            }
            this.setLow(n, -1);
            this.setNext(n, this.freepos);
            this.freepos = n;
            ++this.freenum;
        }
        this.resetCaches();
        ++this.gbcollectnum;
    }

    protected void gbcRehash() {
        this.freepos = 0;
        this.freenum = 0;
        for (int n = this.nodesize - 1; n >= 2; --n) {
            if (this.low(n) != -1) {
                int hash = this.nodehash(this.level(n), this.low(n), this.high(n));
                this.setNext(n, this.hash(hash));
                this.setHash(hash, n);
                continue;
            }
            this.setNext(n, this.freepos);
            this.freepos = n;
            ++this.freenum;
        }
    }

    protected void mark(int i) {
        if (i < 2) {
            return;
        }
        if ((this.level(i) & 0x200000) != 0 || this.low(i) == -1) {
            return;
        }
        this.setLevel(i, this.level(i) | 0x200000);
        this.mark(this.low(i));
        this.mark(this.high(i));
    }

    protected void nodeResize(boolean doRehash) {
        int n;
        int oldsize = this.nodesize;
        this.nodesize <<= 1;
        if (this.nodesize > oldsize + this.maxnodeincrease) {
            this.nodesize = oldsize + this.maxnodeincrease;
        }
        this.nodesize = BDDPrime.primeLTE(this.nodesize);
        int[] newnodes = new int[this.nodesize * 6];
        System.arraycopy(this.nodes, 0, newnodes, 0, this.nodes.length);
        this.nodes = newnodes;
        if (doRehash) {
            for (n = 0; n < oldsize; ++n) {
                this.setHash(n, 0);
            }
        }
        for (n = oldsize; n < this.nodesize; ++n) {
            this.setRefcou(n, 0);
            this.setHash(n, 0);
            this.setLevel(n, 0);
            this.setLow(n, -1);
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodesize - 1, this.freepos);
        this.freepos = oldsize;
        this.freenum += this.nodesize - oldsize;
        if (doRehash) {
            this.gbcRehash();
        }
    }

    protected int refcou(int node) {
        return this.nodes[6 * node];
    }

    protected int level(int node) {
        return this.nodes[6 * node + 1];
    }

    protected int low(int node) {
        return this.nodes[6 * node + 2];
    }

    protected int high(int node) {
        return this.nodes[6 * node + 3];
    }

    protected int hash(int node) {
        return this.nodes[6 * node + 4];
    }

    protected int next(int node) {
        return this.nodes[6 * node + 5];
    }

    protected void setRefcou(int node, int refcou) {
        this.nodes[6 * node] = refcou;
    }

    protected void setLevel(int node, int level) {
        this.nodes[6 * node + 1] = level;
    }

    protected void setLow(int node, int low) {
        this.nodes[6 * node + 2] = low;
    }

    protected void setHigh(int node, int high) {
        this.nodes[6 * node + 3] = high;
    }

    protected void setHash(int node, int hash) {
        this.nodes[6 * node + 4] = hash;
    }

    protected void setNext(int node, int next) {
        this.nodes[6 * node + 5] = next;
    }

    protected void initRef() {
        this.refstacktop = 0;
    }

    protected int pushRef(int n) {
        this.refstack[this.refstacktop++] = n;
        return n;
    }

    protected int readRef(int n) {
        return this.refstack[this.refstacktop - n];
    }

    protected void popref(int n) {
        this.refstacktop -= n;
    }

    protected boolean hasref(int n) {
        return this.refcou(n) > 0;
    }

    protected boolean isConst(int n) {
        return n < 2;
    }

    protected boolean isOne(int n) {
        return n == 1;
    }

    protected boolean isZero(int n) {
        return n == 0;
    }

    protected boolean marked(int n) {
        return (this.level(n) & 0x200000) != 0;
    }

    protected void setMark(int n) {
        this.setLevel(n, this.level(n) | 0x200000);
    }

    protected void unmarkNode(int n) {
        this.setLevel(n, this.level(n) & 0x1FFFFF);
    }

    protected int nodehash(int lvl, int l, int h) {
        return Math.abs(this.triple(lvl, l, h) % this.nodesize);
    }

    protected int pair(int a, int b) {
        return (a + b) * (a + b + 1) / 2 + a;
    }

    protected int triple(int a, int b, int c) {
        return this.pair(c, this.pair(a, b));
    }

    protected void initOperators(int cachesize) {
        this.applycache = new BDDCache(cachesize);
        this.itecache = new BDDCache(cachesize);
        this.quantcache = new BDDCache(cachesize);
        this.appexcache = new BDDCache(cachesize);
        this.replacecache = new BDDCache(cachesize);
        this.misccache = new BDDCache(cachesize);
        this.quantvarsetID = 0;
        this.quantvarset = null;
    }

    protected void resetCaches() {
        this.applycache.reset();
        this.itecache.reset();
        this.quantcache.reset();
        this.appexcache.reset();
        this.replacecache.reset();
        this.misccache.reset();
    }

    protected void varResize() {
        this.quantvarset = new int[this.varnum];
        this.quantvarsetID = 0;
    }

    public BDDStatistics statistics() {
        BDDStatistics statistics = new BDDStatistics();
        statistics.produced = this.produced;
        statistics.nodesize = this.nodesize;
        statistics.freenum = this.freenum;
        statistics.varnum = this.varnum;
        statistics.cachesize = this.cachesize;
        statistics.gbcollectnum = this.gbcollectnum;
        return statistics;
    }

    @FunctionalInterface
    protected static interface BddOperation {
        public int perform() throws BddReorderRequest;
    }

    protected static class BddReorderRequest
    extends RuntimeException {
        protected BddReorderRequest() {
        }
    }

    public static class BDDStatistics {
        protected long produced;
        protected int nodesize;
        protected int freenum;
        protected int varnum;
        protected int cachesize;
        protected int gbcollectnum;

        public long produced() {
            return this.produced;
        }

        public int nodesize() {
            return this.nodesize;
        }

        public int freenum() {
            return this.freenum;
        }

        public int varnum() {
            return this.varnum;
        }

        public int cachesize() {
            return this.cachesize;
        }

        public int gbcollectnum() {
            return this.gbcollectnum;
        }

        public int usedNodes() {
            return this.nodesize - this.freenum;
        }

        public String toString() {
            return "BDDStatistics{produced nodes=" + this.produced + ", allocated nodes=" + this.nodesize + ", free nodes=" + this.freenum + ", variables=" + this.varnum + ", cache size=" + this.cachesize + ", garbage collections=" + this.gbcollectnum + '}';
        }
    }

    protected static enum Operand {
        AND(0, new int[]{0, 0, 0, 1}),
        OR(2, new int[]{0, 1, 1, 1}),
        IMP(5, new int[]{1, 1, 0, 1}),
        EQUIV(6, new int[]{1, 0, 0, 1}),
        NOT(10, new int[]{1, 1, 0, 0});

        protected final int v;
        protected final int[] tt;

        private Operand(int value, int[] truthTable) {
            this.v = value;
            this.tt = truthTable;
        }
    }
}

