/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.jbuddy;

import org.logicng.knowledgecompilation.bdds.jbuddy.BDDCacheEntry;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;

public class BDDConstruction {
    private final BDDKernel k;

    public BDDConstruction(BDDKernel k) {
        this.k = k;
    }

    public int ithVar(int i) {
        if (i < 0 || i >= this.k.varnum) {
            throw new IllegalArgumentException("Illegal variable number: " + i);
        }
        return this.k.vars[i * 2];
    }

    public int nithVar(int i) {
        if (i < 0 || i >= this.k.varnum) {
            throw new IllegalArgumentException("Illegal variable number: " + i);
        }
        return this.k.vars[i * 2 + 1];
    }

    public int bddVar(int root) {
        if (root < 2) {
            throw new IllegalArgumentException("Illegal node number: " + root);
        }
        return this.k.level2var[this.k.level(root)];
    }

    public int bddLow(int root) {
        if (root < 2) {
            throw new IllegalArgumentException("Illegal node number: " + root);
        }
        return this.k.low(root);
    }

    public int bddHigh(int root) {
        if (root < 2) {
            throw new IllegalArgumentException("Illegal node number: " + root);
        }
        return this.k.high(root);
    }

    public int and(int l, int r) {
        return this.k.apply(l, r, BDDKernel.Operand.AND);
    }

    public int or(int l, int r) {
        return this.k.apply(l, r, BDDKernel.Operand.OR);
    }

    public int implication(int l, int r) {
        return this.k.apply(l, r, BDDKernel.Operand.IMP);
    }

    public int equivalence(int l, int r) {
        return this.k.apply(l, r, BDDKernel.Operand.EQUIV);
    }

    public int not(int r) {
        return this.k.doWithPotentialReordering(() -> this.notRec(r));
    }

    protected int notRec(int r) throws BDDKernel.BddReorderRequest {
        if (this.k.isZero(r)) {
            return 1;
        }
        if (this.k.isOne(r)) {
            return 0;
        }
        BDDCacheEntry entry = this.k.applycache.lookup(r);
        if (entry.a == r && entry.c == BDDKernel.Operand.NOT.v) {
            return entry.res;
        }
        this.k.pushRef(this.notRec(this.k.low(r)));
        this.k.pushRef(this.notRec(this.k.high(r)));
        int res = this.k.makeNode(this.k.level(r), this.k.readRef(2), this.k.readRef(1));
        this.k.popref(2);
        entry.a = r;
        entry.c = BDDKernel.Operand.NOT.v;
        entry.res = res;
        return res;
    }

    public int restrict(int r, int var) {
        if (var < 2) {
            return r;
        }
        this.varset2svartable(var);
        return this.k.doWithPotentialReordering(() -> this.restrictRec(r, var << 3 | 1));
    }

    protected int restrictRec(int r, int miscid) throws BDDKernel.BddReorderRequest {
        int res;
        if (this.k.isConst(r) || this.k.level(r) > this.k.quantlast) {
            return r;
        }
        BDDCacheEntry entry = this.k.misccache.lookup(this.k.pair(r, miscid));
        if (entry.a == r && entry.c == miscid) {
            return entry.res;
        }
        if (this.insvarset(this.k.level(r))) {
            res = this.k.quantvarset[this.k.level(r)] > 0 ? this.restrictRec(this.k.high(r), miscid) : this.restrictRec(this.k.low(r), miscid);
        } else {
            this.k.pushRef(this.restrictRec(this.k.low(r), miscid));
            this.k.pushRef(this.restrictRec(this.k.high(r), miscid));
            res = this.k.makeNode(this.k.level(r), this.k.readRef(2), this.k.readRef(1));
            this.k.popref(2);
        }
        entry.a = r;
        entry.c = miscid;
        entry.res = res;
        return res;
    }

    public int exists(int r, int var) {
        if (var < 2) {
            return r;
        }
        this.varset2vartable(var);
        return this.k.doWithPotentialReordering(() -> this.quantRec(r, BDDKernel.Operand.OR, var << 3));
    }

    public int forAll(int r, int var) {
        if (var < 2) {
            return r;
        }
        this.varset2vartable(var);
        return this.k.doWithPotentialReordering(() -> this.quantRec(r, BDDKernel.Operand.AND, var << 3 | 1));
    }

    protected int quantRec(int r, BDDKernel.Operand op, int quantid) throws BDDKernel.BddReorderRequest {
        if (r < 2 || this.k.level(r) > this.k.quantlast) {
            return r;
        }
        BDDCacheEntry entry = this.k.quantcache.lookup(r);
        if (entry.a == r && entry.c == quantid) {
            return entry.res;
        }
        this.k.pushRef(this.quantRec(this.k.low(r), op, quantid));
        this.k.pushRef(this.quantRec(this.k.high(r), op, quantid));
        int res = this.invarset(this.k.level(r)) ? this.k.applyRec(this.k.readRef(2), this.k.readRef(1), op) : this.k.makeNode(this.k.level(r), this.k.readRef(2), this.k.readRef(1));
        this.k.popref(2);
        entry.a = r;
        entry.c = quantid;
        entry.res = res;
        return res;
    }

    protected void varset2svartable(int r) {
        if (r < 2) {
            throw new IllegalArgumentException("Illegal variable: " + r);
        }
        ++this.k.quantvarsetID;
        if (this.k.quantvarsetID == 0x3FFFFFFF) {
            this.k.quantvarset = new int[this.k.varnum];
            this.k.quantvarsetID = 1;
        }
        int n = r;
        while (!this.k.isConst(n)) {
            if (this.k.isZero(this.k.low(n))) {
                this.k.quantvarset[this.k.level((int)n)] = this.k.quantvarsetID;
                n = this.k.high(n);
            } else {
                this.k.quantvarset[this.k.level((int)n)] = -this.k.quantvarsetID;
                n = this.k.low(n);
            }
            this.k.quantlast = this.k.level(n);
        }
    }

    protected void varset2vartable(int r) {
        if (r < 2) {
            throw new IllegalArgumentException("Illegal variable: " + r);
        }
        ++this.k.quantvarsetID;
        if (this.k.quantvarsetID == Integer.MAX_VALUE) {
            this.k.quantvarset = new int[this.k.varnum];
            this.k.quantvarsetID = 1;
        }
        int n = r;
        while (n > 1) {
            this.k.quantvarset[this.k.level((int)n)] = this.k.quantvarsetID;
            this.k.quantlast = this.k.level(n);
            n = this.k.high(n);
        }
    }

    protected boolean insvarset(int a) {
        return Math.abs(this.k.quantvarset[a]) == this.k.quantvarsetID;
    }

    protected boolean invarset(int a) {
        return this.k.quantvarset[a] == this.k.quantvarsetID;
    }
}

