/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDOperations;

public final class BDDDotFileWriter {
    private static final String CONST_TRUE = "const_true";
    private static final String CONST_FALSE = "const_false";
    private static final String NODE_PREFIX = "id_";

    private BDDDotFileWriter() {
    }

    public static void write(String fileName, BDD bdd) throws IOException {
        BDDDotFileWriter.write(new File(fileName.endsWith(".dot") ? fileName : fileName + ".dot"), bdd);
    }

    public static void write(File file, BDD bdd) throws IOException {
        StringBuilder sb = new StringBuilder(String.format("digraph G {%n", new Object[0]));
        if (!bdd.isContradiction()) {
            sb.append(String.format("  %s [shape=box, label=\"$true\", style = bold, color = darkgreen];%n", CONST_TRUE));
        }
        if (!bdd.isTautology()) {
            sb.append(String.format("  %s [shape=box, label=\"$false\", style = bold, color = red];%n", CONST_FALSE));
        }
        for (int[] internalNode : new BDDOperations(bdd.underlyingKernel()).allNodes(bdd.index())) {
            sb.append(String.format("  %s%d [shape=ellipse, label=\"%s\"];%n", NODE_PREFIX, internalNode[0], bdd.underlyingKernel().getVariableForIndex(internalNode[1]).name()));
            sb.append(String.format("  %s%d -> %s [style = dotted, color = red];%n", NODE_PREFIX, internalNode[0], BDDDotFileWriter.getNodeString(internalNode[2])));
            sb.append(String.format("  %s%d -> %s [color = darkgreen];%n", NODE_PREFIX, internalNode[0], BDDDotFileWriter.getNodeString(internalNode[3])));
        }
        sb.append("}").append(System.lineSeparator());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.append(sb);
            writer.flush();
        }
    }

    private static String getNodeString(int i) {
        switch (i) {
            case 0: {
                return CONST_FALSE;
            }
            case 1: {
                return CONST_TRUE;
            }
        }
        return NODE_PREFIX + i;
    }
}

