/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDConstant;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDInnerNode;
import org.logicng.knowledgecompilation.bdds.datastructures.BDDNode;
import org.logicng.knowledgecompilation.bdds.functions.BDDFunction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDOperations;

public final class LngBDDFunction
implements BDDFunction<BDDNode> {
    @Override
    public BDDNode apply(BDD bdd) {
        BDDKernel kernel = bdd.underlyingKernel();
        int index = bdd.index();
        Map<Integer, int[]> kernelNodeMap = new BDDOperations(kernel).allNodes(index).stream().collect(Collectors.toMap(node -> node[0], node -> node));
        return this.buildBDDNode(index, kernel, kernelNodeMap, new HashMap<Integer, BDDNode>());
    }

    private BDDNode buildBDDNode(int index, BDDKernel kernel, Map<Integer, int[]> kernelNodeMap, Map<Integer, BDDNode> nodeMap) {
        BDDNode node = nodeMap.get(index);
        if (node != null) {
            return node;
        }
        if (index == 0) {
            node = BDDConstant.getFalsumNode(kernel.factory());
        } else if (index == 1) {
            node = BDDConstant.getVerumNode(kernel.factory());
        } else {
            int[] kernelNode = kernelNodeMap.get(index);
            Variable variable = kernel.getVariableForIndex(kernelNode[1]);
            BDDNode lowNode = this.buildBDDNode(kernelNode[2], kernel, kernelNodeMap, nodeMap);
            BDDNode highNode = this.buildBDDNode(kernelNode[3], kernel, kernelNodeMap, nodeMap);
            node = new BDDInnerNode(variable, lowNode, highNode);
        }
        nodeMap.put(index, node);
        return node;
    }
}

