/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Variable;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.functions.BDDFunction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDOperations;

public final class BDDModelEnumerationFunction
implements BDDFunction<List<Assignment>> {
    private final Collection<Variable> variables;

    public BDDModelEnumerationFunction(Collection<Variable> variables) {
        this.variables = variables;
    }

    @Override
    public List<Assignment> apply(BDD bdd) {
        TreeSet<Object> temp;
        HashSet<Assignment> res = new HashSet<Assignment>();
        BDDKernel kernel = bdd.underlyingKernel();
        List<byte[]> models = new BDDOperations(kernel).allSat(bdd.index());
        if (this.variables == null) {
            temp = new TreeSet<Integer>(kernel.var2idx().values());
        } else {
            temp = new TreeSet();
            for (Map.Entry<Variable, Integer> e : kernel.var2idx().entrySet()) {
                if (!this.variables.contains(e.getKey())) continue;
                temp.add(e.getValue());
            }
        }
        int[] relevantIndices = new int[temp.size()];
        int count = 0;
        for (Integer n : temp) {
            relevantIndices[count++] = n;
        }
        for (byte[] byArray : models) {
            ArrayList<Assignment> allAssignments = new ArrayList<Assignment>();
            this.generateAllModels(kernel, allAssignments, byArray, relevantIndices, 0);
            res.addAll(allAssignments);
        }
        return new ArrayList<Assignment>(res);
    }

    private void generateAllModels(BDDKernel kernel, List<Assignment> assignments, byte[] model, int[] relevantIndices, int position) {
        if (position == relevantIndices.length) {
            Assignment assignment = new Assignment();
            for (int i : relevantIndices) {
                assignment.addLiteral(model[i] == 0 ? kernel.getVariableForIndex(i).negate() : kernel.getVariableForIndex(i));
            }
            assignments.add(assignment);
        } else if (model[relevantIndices[position]] != -1) {
            this.generateAllModels(kernel, assignments, model, relevantIndices, position + 1);
        } else {
            model[relevantIndices[position]] = 0;
            this.generateAllModels(kernel, assignments, model, relevantIndices, position + 1);
            model[relevantIndices[position]] = 1;
            this.generateAllModels(kernel, assignments, model, relevantIndices, position + 1);
            model[relevantIndices[position]] = -1;
        }
    }
}

