/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.knowledgecompilation.bdds.functions;

import java.util.ArrayList;
import java.util.List;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.knowledgecompilation.bdds.BDD;
import org.logicng.knowledgecompilation.bdds.functions.BDDFunction;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDOperations;

public final class BDDCNFFunction
implements BDDFunction<Formula> {
    @Override
    public Formula apply(BDD bdd) {
        BDDKernel kernel = bdd.underlyingKernel();
        List<byte[]> unsatPaths = new BDDOperations(kernel).allUnsat(bdd.index());
        ArrayList<Formula> clauses = new ArrayList<Formula>();
        for (byte[] path : unsatPaths) {
            ArrayList<Literal> literals = new ArrayList<Literal>();
            for (int i = 0; i < path.length; ++i) {
                if (path[i] == 0) {
                    literals.add(kernel.getVariableForIndex(i));
                    continue;
                }
                if (path[i] != 1) continue;
                literals.add(kernel.getVariableForIndex(i).negate());
            }
            clauses.add(kernel.factory().or(literals));
        }
        return kernel.factory().and(clauses);
    }
}

